'GHINI RUN v1.11
'
'MARCUS KASUMBA 2002
'
'http://piptol.cjb.net
'--------------------------------------------------------------------------
' This source code has been released due to popular demand, rather then
' me thinking it would be easy to learn from. I don't tend to
' comment my code very well, and often the comments will only be
' meanful to me. Sorry, bad habits die hard but hopefully it's not
' too tangled ;-)
'
' QS<name> routines are my own simplified interfaces (usually) to other libs
' (such as Dash, etc) and make it easy for me to update the code if
' I ever find a better routine.
'
'--------------------------------------------------------------------------

DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'gr.bi'
'$INCLUDE: 'ds4qbpp.BI'
'$INCLUDE: 'Dextern.bi'

'SPRITE ARRAYS MUST BE SETUP BEFORE LOAD

DIM SHARED spr(14000)
DIM SHARED sprite(LASTSPRITE - 1) AS spriteClass
DIM SHARED memMode

'LOADER ))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))
CLS : COLOR 15, 1
PRINT " 'GHINI RUN"; SPACE$(45); "(c) Marcus Kasumba 2002 "
COLOR 15, 0
PRINT
PRINT "Version 1.11"
PRINT
IF NOT FileExsist("soundsys.cfg") THEN
   PRINT "Please run SETUP.EXE first"
   END
END IF

PRINT "Allocating EMS.. ";
' DQBInit (Layers, Sounds, Custom EMS)
IF DQBinit(0, 0, 1000) THEN
   PRINT "FAILED"
   COLOR 4, 0
   PRINT : PRINT "WARNING - Performance may be severely affected without EMS!"
   PRINT : memMode = 1: SLEEP 2: COLOR 15, 0
   DQBclose
   IF DQBinit(0, 0, 0) THEN
      DQBclose
      PRINT DQBerror$
      END
   END IF
ELSE
   PRINT "OK"
END IF


PRINT "Install keyboard.. ";
DQBInstallKeyboard
PRINT "OK"

PRINT "Extract GFX... ";
IF FARExist%("data\ghini.dat") <> 0 THEN PRINT "File GHINI.DAT not found": GOTO shutDown
archHandle = FAROpen%("data\ghini.dat")
PRINT "OK"
PRINT "Load GFX.. ";
loadGfx

PRINT : PRINT "Initialise sound.. ";
FOR I = 1 TO 2
   ii = DS4QB.Init(CURRENT, DEFAULT)
   IF ii = 0 THEN
      PRINT "OK"
      initSnd
      EXIT FOR
   ELSEIF ii = 999 THEN
      PRINT "N/A"
      ii = 0
      EXIT FOR
   ELSE
      PRINT "FAILED": PRINT "Retrying.. ";
      SLEEP 2
   END IF
NEXT I


IF ii <> 0 THEN PRINT "Error": GOTO shutDown


PRINT "Init timers...";
CSInstallTimer
CSSetTimer 0, 10 'frame ctrl
CSSetTimer 1, 200 'bird flap
CSSetTimer 3, 600 'skid ctrl
gsinit
PRINT "OK"


'))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))


'SETUP VARBS
DIM gearPow(1 TO 6) AS INTEGER
DIM gearShift(2 TO 6) AS INTEGER
DIM car(7) AS vehicle
DIM stepper(4) AS INTEGER
DIM stepsprL(4) AS INTEGER
DIM stepsprR(4) AS INTEGER
DIM stepsprLM(4) AS INTEGER
DIM stepsprRM(4) AS INTEGER
DIM stepsprTM(4) AS INTEGER
DIM stepsprT(4) AS INTEGER
DIM scenName(3) AS INTEGER
DIM scenYpos(3) AS INTEGER
DIM scen(3) AS INTEGER
DIM scenMF(3) AS INTEGER
DIM course(600) AS INTEGER
DIM config(13) AS INTEGER
DIM buffer(32001) AS INTEGER

dump 3
IF recordCtrl(888) THEN PRINT "Reseting hiscores": I = recordCtrl(999): SLEEP 2

RANDOMIZE TIMER

vsgraphics
vspalette "data\ghini"
DS4QB.PlayMusic 7
startScreen
newDriver


'****************************** RESTART ***********************
DO
   
   CALL Restart
   
   IF code = 999 THEN grWipe: EXIT DO'drop through to 'shutDown'
   
   carSetup
   CSSetTimer 0, 1000 \ config(0) 'game speed control
   CSSetTimer 2, 125 + (config(13) * 200) 'sound ctrl timer
   startRace
   '********************* MAIN LOOP **********************
   
   
   DO
      Frame
      playerCarCtrl
      updateAllCarPos
      frameOverlays
      sndFlush
      QSU
      
      
      'Race completed
      IF code = 100 AND car(0).MPH = 0 THEN EXIT DO
      
      
      'ESC pressed
      IF code = 101 THEN EXIT DO
      
      
      'time out
      IF countDown = 0 THEN code = 102: EXIT DO
      
      
   LOOP
   
   
   '*********************** END MAIN *********************
   
   
   'Game has ended.. let's work out why

   SELECT CASE code

      CASE 100: QSTextSp "race complete`", 999, 90, 0
	 IF thisGame > 18 THEN
	    QSText "BONUS +" + STR$(countDown * 10), 200, 25, 47
	    points = points + countDown * (10 + config(4) * 5)
	    IF racePos = 1 AND config(3) = game2track(thisGame) + 1 THEN
	       QSTextSp "new car unlocked`", 999, 60, 0
	       DS4QB.PlaySound 17
	       config(3) = config(3) + 1
	    END IF
	 END IF
	 
	 'compare & update
	 IF recordCtrl(0) = 1 THEN
	    QSTextSp "new record`", 999, 120, 0
	 END IF
	 
	 
      CASE 101: QSTextSp "game aborted", 999, 90, 0
      CASE 102: QSTextSp "time over`", 999, 90, 0
	 
	 
   END SELECT
   
   QSU
   CSSetTimer 0, 10
   SLEEP 3
   
   
   'We need to stop any 'continuous' sound FX
   
   
   FOR I = 0 TO 1 'do it twice just to make sure.. it's DS4QB
      FOR ii = 1 TO 27
	 DS4QB.StopSound ii
      NEXT ii
   NEXT I
   
   
   IF code = 100 THEN raceResults
   QSfadeDown
   DS4QB.StopMusic game2track(thisGame)
   DS4QB.PlayMusic 7
   
LOOP
'*************************** END RESTART ***********************


shutDown:
vstext
PRINT "Shutting down - this may take a moment..";
dump 2
CSRemoveTimer
SLEEP 2
DS4QB.StopMusic 7
DS4QB.Close
IF FARClose%(archHandle) <> 0 THEN PRINT "ERROR CLOSING ARCHIVE"
DQBclose
PRINT "OK"
SYSTEM


gearDat:
'gearPow, gearShift, etc
'skidlimit, handling, brakes
'negative nos. are +N per frame

'1 - Lamborghini
DATA -1,30,-1,60,1,80,2,121,5,210,0
DATA 190,10,1

'2 - Corvette
DATA -1,24,-1,55,1,70,2,123,5,200,0
DATA 250,10,5

'3 - Maserati
DATA -1,20,-1,42,1,66,3,109,5,162,7
DATA 150,10,2

'4 - Sunchaser
DATA -1,32,-1,74,1,98,2,140,4,205,0
DATA 210,10,1

'5 - Porsche
DATA -1,20,-1,50,1,70,2,123,5,151,6
DATA 120,11,4

'6 - Cruiser
DATA -1,23,-1,42,1,65,2,128,5,169,6
DATA 350,9,4

'7 - Ferrari
DATA -1,35,-1,67,2,84,3,130,5,172,6
DATA 200,10,3

'8 - Viper
DATA -1,40,-1,65,1,91,2,123,4,149,6
DATA 150,10,1

'9 - Police
DATA -1,33,-1,60,-1,77,1,123,2,155,3
DATA 200,10,5
carNames:
DATA lamborghini,4,4,4,3,2
DATA corvette,3,2,5,4,6
DATA maserati,2,5,4,2,3
DATA sunchaser,6,3,5,3,2
DATA porsche,3,3,6,2,4
DATA cruiser,3,4,2,6,4
DATA ferrari,4,5,3,4,3
DATA viper,5,6,3,2,2
'DATA Special PD,2,4,5,3,6
speedDat:
DATA 208,191,212,198,196,204,215,221,241
menuDat:
DATA Race,Driver,Records,Options,Credits,Quit
recSelDat:
DATA ARCADE,SHOTGUN RUN,TIME ATTACK,PURSUIT
driverDat:
DATA MARC,KISA,JUBE,BECKS,HANS,TOMMY,GINO,DALEY
musDat:
DATA 90,75,70,100,98,90,100,100
trackSpeedDat:
DATA 180,170,160,160,160,150
trackData:
DATA Track1
DATA "BLUEWATER BAY"
DATA "Coastal road consisting of long gentle"
DATA "curves. High speed course, prone to"
DATA "drifting sand in places."

DATA Track2
DATA "CASTLE FIELDS"
DATA "Medieval site long since overgrown with"
DATA "wild orchards and flowers. Beware tight"
DATA "bends off the hills."

DATA Track3
DATA "CAPITAL NIGHTS"
DATA "A race through the winding streets of"
DATA "Saint George City. Keep an eye on the"
DATA "road signs."

DATA Track4
DATA "SUNSET LAGOON"
DATA "Tropical course famous for spectacular"
DATA "evening sunset. Road surface is poor"
DATA "and prone to flooding."

DATA Track5
DATA "AZURE FALLS"
DATA "The beautiful scenery hides a tough"
DATA "path through the Falls. Beware, the"
DATA "road is slippery when wet."


DATA Track6
DATA "WILD ICE ROAD"
DATA "Notoriously difficult road winds"
DATA "through the mountains, and is normally"
DATA "only attemped in Off-Road vehcles!"

credDat:
DATA "a game by","marcus kasumba    ","2002",""
DATA "coded in quickbasic`",""
DATA "credits",""
DATA "game code and graphics","marcus kasumba",""
DATA "dash library","danny gump",""
DATA "gs library","jason gould",""
DATA "directqb ems and keyboard","angelo mottola",""
DATA "cosmox timers","bobby",""
DATA "direct sound for qbpp","chris adams aka lithium",""
DATA "far qb","eric cowles",""
DATA "testing","plasma  ","357","",""
DATA "thanks","",wildcard,vance,qbshire,bobby,relsoft,mr moose
DATA "and everyone else who","supported me",""
DATA "and you for playing`","",""
DATA "ghini run",catch me if you can`"
DATA ENDLIST

REM $STATIC
FUNCTION askGameType

'WHAT DOES IT DO? : Displays game choice screen & returns value selected
   
   repKey = 1
   hLighted = 1
   
   
   DO
      blueTile 0
      
      
      RESTORE recSelDat
      FOR ii = 1 TO 4
	 READ a$
	 IF ii = hLighted THEN
	    QSTextSp a$, 999, (ii * 25) + 30, 2229
	 ELSE
	    QSTextSp a$, 999, (ii * 25) + 30, 0
	 END IF
      NEXT ii
      QSU
      
      
      'menu control
      'clear 'QSkey buffer'
      IF NOT DQBkey(config(8)) AND NOT DQBkey(config(9)) AND NOT DQBkey(config(6)) THEN repKey = 0
      
      IF hLighted > 1 AND repKey = 0 AND DQBkey(config(8)) THEN hLighted = hLighted - 1: repKey = 1
      IF hLighted < 4 AND repKey = 0 AND DQBkey(config(9)) THEN hLighted = hLighted + 1: repKey = 1
      IF DQBkey(config(6)) AND repKey = 0 THEN EXIT DO
      IF DQBkey(config(7)) AND repKey = 0 THEN hLighted = 999: EXIT DO
   LOOP
   
   askGameType = hLighted
   
   
END FUNCTION

SUB blueTile (mode%) STATIC
   
'WHAT DOES IT DO? : Tiles the screen with the GR logo 
   
   DIM Slot(2)
   
   IF Slot(0) = Slot(2) AND Slot(0) = 0 THEN
      'its the 1st time
      Slot(0) = 200: Slot(2) = 220
      scenA = 5: scenB = 1
   END IF
  
   
   FOR x = -79 TO 319 STEP 80
      FOR y = -49 TO 199 STEP 50
	 QSpriteT 118, x + xmod, y + ymod
      NEXT y
   NEXT x
   
   xmod = xmod + 1: IF xmod = 80 THEN xmod = 0
   ymod = ymod + 1: IF ymod = 50 THEN ymod = 0
   
   
   IF mode% = 1 THEN EXIT SUB
   
   
   'twirly stuff
   QSpriteR 94, Slot(0), 130, r2, 80
   QSpriteR scenA, Slot(1), 50, r, 128
   QSpriteR 93, Slot(0), 80, r2, 80
   QSpriteR scenB, Slot(2), 150, r, 128
   
   
   r = r + 2: IF r >= 360 THEN r = 0
   r2 = r2 - 2: IF r2 <= 0 THEN r2 = 359
   
   
   Slot(0) = Slot(0) + 1: IF Slot(0) > 360 THEN Slot(0) = -40
   
   
   'reuse x to avoid STATIC waste
   FOR x = 1 TO 2
      Slot(x) = Slot(x) - 2
      IF Slot(x) < -40 THEN
	 Slot(x) = 360
	 IF x = 1 THEN scenA = scenA + 1: IF scenA = 10 THEN scenA = 1
	 IF x = 2 THEN scenB = scenB + 1: IF scenB = 10 THEN scenB = 1
      END IF
   NEXT x
   
   
   
   
END SUB

REM $DYNAMIC
SUB carSelect
  
'WHAT DOES IT DO? : Car select screen. Car type held in global 'yourCarModel'

   startx = 160: startY = 90
   repKey = 1
   
   
   DO
      blueTile 1
      
      
      QSpriteS currCar + 1, 160, startY, 118
      
      
      IF NOT DQBkey(config(6)) AND NOT DQBkey(config(7)) AND NOT DQBkey(config(10)) AND NOT DQBkey(config(11)) THEN repKey = 0
      
      
      pre = currCar
      IF DQBkey(config(6)) AND repKey = 0 AND config(3) >= currCar THEN EXIT DO
      IF DQBkey(config(7)) AND repKey = 0 THEN currCar = 9998: EXIT DO
      
      IF DQBkey(config(10)) AND repKey = 0 THEN currCar = currCar - 1: repKey = 1
      IF DQBkey(config(11)) AND repKey = 0 THEN currCar = currCar + 1: repKey = 1
      IF currCar = 8 THEN currCar = 7
      IF currCar = -1 THEN currCar = 0
      
      
      IF pre < currCar THEN 'shift right
	 
	 
	 ii = 118
	 FOR I = startx TO -80 STEP -4
	    
	    
	    blueTile 1
	    QSTextSp "Select car", 999, 17, 0
	    IF ii > 0 THEN QSpriteS pre + 31, I, startY, ii
	    QSpriteS currCar + 21, I + 240, startY, 118 - ii
	    ii = ii - 2
	    QSU
	 NEXT I
	 
	 
      ELSEIF pre > currCar THEN 'shift left
	 
	 
	 ii = 118
	 FOR I = startx TO 400 STEP 4
	    
	    
	    blueTile 1
	    QSTextSp "Select car", 999, 17, 0
	    IF ii > 0 THEN QSpriteS pre + 21, I, startY, ii
	    QSpriteS currCar + 31, I - 240, startY, 118 - ii
	    ii = ii - 2
	    QSU
	    
	 NEXT I
      ELSE
	 RESTORE carNames
	 FOR I = 0 TO currCar
	    READ a$
	    
	    
	    READ a
	    IF I = currCar THEN
	       mx = 85: my = 140
	       QSText "ACCEL", mx, my, 47
	       GOSUB statBlock
	    END IF
	    
	    
	    READ a
	    
	    
	    IF I = currCar THEN
	       my = my + 10
	       QSText "SPEED", mx, my, 47
	       GOSUB statBlock
	    END IF
	    
	    
	    READ a
	    
	    
	    IF I = currCar THEN
	       my = my + 10
	       QSText "HANDL", mx, my, 47
	       GOSUB statBlock
	    END IF
	    
	    
	    READ a
	    
	    
	    IF I = currCar THEN
	       my = my + 10
	       QSText "TYRES", mx, my, 47
	       GOSUB statBlock
	    END IF
	    
	    
	    READ a
	    
	    
	    IF I = currCar THEN
	       my = my + 10
	       QSText "BRAKE", mx, my, 47
	       GOSUB statBlock
	    END IF
	    
	    
	    
	    
	 NEXT I
	 
	 
	 IF config(3) >= currCar THEN
	    QSTextSp "Select car", 999, 17, 0
	 ELSE
	    QSTextSp "not available`", 999, 17, 0
	 END IF
	 
	 
	 QSTextSp a$, 70, 115, 0 'car name
      END IF
      
      
      QSU
   LOOP
   
   
   yourcarModel = currCar + 1
   
   EXIT SUB
   
   
statBlock:
   FOR ii = 1 TO a
      QSBox ((ii * 24) + mx + 30), my + 1, ((ii * 24) + mx + 52), my + 6, 67 + (ii * 2)
      QSBox ((ii * 24) + mx + 31), my + 2, ((ii * 24) + mx + 52), my + 6, 66 + (ii * 2)
      
   NEXT ii
   RETURN
END SUB

SUB carSetup

'WHAT DOES IT DO? : Sets up car attributes

   'Setup Your Car Data
   'Car MODEL is from 1 to 9
   RESTORE gearDat
   FOR j = 1 TO yourcarModel
      READ a
      gearPow(1) = a
      FOR I = 2 TO 6
	 READ a
	 gearShift(I) = a
	 READ a
	 gearPow(I) = a
      NEXT I
      
      
      READ a: skidLimit = a
      READ a: handling = a
      READ a: brakes = a
      
   NEXT j
   
   
   RESTORE speedDat
   FOR j = 1 TO yourcarModel
      READ a
      car(0).maxMPH = a
      car(0).sprite = j
   NEXT j
   
   
   
   
   steerSpr = car(0).sprite
   
   
   'prep cars
   IF totalCars = 0 THEN EXIT SUB
   
   
   DIM model(totalCars)
   
   
   'set the car speeds
   RESTORE trackSpeedDat
   FOR k = 1 TO game2track(thisGame)
      READ a
      car(1).maxMPH = a - ((2 - config(4)) * 10)
   NEXT k
   
   
   
   
   FOR I = 1 TO totalCars
      
      DO
	 carModel = Dicef(8)
	 a = 0 'flag
	 FOR j = 0 TO totalCars
	    IF carModel = car(j).sprite THEN a = 1
	 NEXT j
      LOOP UNTIL a = 0
      car(I).sprite = carModel
      
      
      car(I).dist = ((totalCars - I) * 15) + 60
      car(I).hOffset = -Dicef(2) - 1
      
      IF I > 1 THEN
	 car(I).maxMPH = car(I - 1).maxMPH - 15
	 IF I MOD 2 THEN car(I).hOffset = car(I - 1).hOffset + 5
      END IF
      
      
   NEXT I
   
   
   
   
END SUB

SUB clearVarbs
   
'WHAT DOES IT DO? : Resets variables for a new game
   
   
   code = 0: codeDur = 0: codePtr = 0: codeInt = 0
   carCode = 0: carCodeDur = 0: carCodePtr = 0: carCodeInt = 0
   rbend = 0: rbendt = 0: hz = 0: vert = 0: cRbend = 0: cRbendt = 0
   rainFact = 0: trackSkid = 0: points = 0: wSpray = 0
   countNextL = 0: countNextR = 0: countNextT = 0
   
   
   REDIM car(7) AS vehicle
   
   
   IF thisGame < 8 OR thisGame > 12 THEN raceMins = 0: raceSecs = 0: race20s = 0
   topSpeed = 0: racePos = totalCars + 1
   clockRun = 0
   
   
   'set the time limit
   IF thisGame > 18 THEN
      countDown = 99 'for pursuit mode
   ELSE
      countDown = 69 + ((2 - config(4)) * 7)
   END IF
   
   
END SUB

REM $STATIC
FUNCTION Dicef% (sides%)

'WHAT DOES IT DO? : Dice rolling function, returns roll.

   Dicef = INT(RND * sides) + 1
END FUNCTION

SUB dispTime (min%, sec%, subsec%, x%, y%)
   
'WHAT DOES IT DO? : Displays given time

   'min
   
   IF min% > 10 THEN
      GFXnum min%, x%, y%, 0
   ELSE
      GFXnumS "0" + LTRIM$(STR$(min%)), x%, y%, 0
   END IF
   
   
   IF sec% < 10 THEN
      GFXnumS "0" + LTRIM$(STR$(sec%)), x% + 31, y%, 0
   ELSE
      GFXnum sec%, x% + 31, y%, 0
   END IF
   
   
   IF subsec% < 10 THEN
      GFXnumS "0" + LTRIM$(STR$(subsec%)), x% + 62, y%, 0
   ELSE
      GFXnum subsec%, x% + 62, y%, 0
   END IF
   
   
   QSprite 82, x% + 28, y% - 2'blip
   QSprite 82, x% + 59, y% - 2'blip
   QSprite 82, x% + 62, y% - 2'blip
   
   
END SUB

SUB dump (mode%)
  
'WHAT DOES IT DO? : Save/load game config to file
   
   'config(N) values. N=
   '0 - FPS
   '1 - VSYNC
   '2 - trackLimit
   '3 - carLimit
   '4 - difficulty
   '5 - record checksum
   '6 - accel (or 9999 if joystick mode)
   '7 - brake
   '8 - up
   '9 - down
   '10- left
   '11- right
   '12- pause
   '13- sound lag
   SELECT CASE mode%
      
      
      CASE 2: 'save config
	 DEF SEG = VARSEG(config(0))
	 BSAVE "data\config.dat", VARPTR(config(0)), 28
	 DEF SEG
	 
	 
      CASE 3: 'load config
	 DEF SEG = VARSEG(config(0))
	 BLOAD "data\config.dat", VARPTR(config(0))
	 DEF SEG
	 
   END SELECT
   
   
   
END SUB

SUB Frame

'WHAT DOES IT DO? : Draws next frame & carries out collision calcs & racePos.

   STATIC stopSiren, bump
   VERTFACTOR = vert * 12
   oldPoints = points
   
   IF bump > 0 THEN bump = bump - 1'used to check for multiple bumps in a given time
   
   'Sky
   IF skyCol < 255 THEN
      QSBox 0, 0, 320, 150, skyCol
      
      'Top part of sky is diff col on castle fields
      IF skyCol = 128 AND vert > 0 THEN QSBox 0, 0, 320, 40, 122
   END IF
   
   
   IF layerScroll < 99 THEN scen(layerScroll) = scen(layerScroll) + 1
   
   
   FOR I = 0 TO 3
      IF scenName(I) <> 999 THEN
	 scen(I) = scen(I) - (car(0).hOffset \ (scenMF(I) + 1))
	 
	 IF scen(I) >= 320 THEN scen(I) = scen(I) - 320
	 IF scen(I) <= -320 THEN scen(I) = scen(I) + 320
	 SELECT CASE scenName(I)
	    CASE IS < 1000: 'normal put
	       QSprite scenName(I), scen(I), scenYpos(I) + (vert * 2)
	       IF scen(I) < 0 THEN QSprite scenName(I), scen(I) + 320, scenYpos(I) + (vert * 2)
	       IF scen(I) > 0 THEN QSprite scenName(I), scen(I) - 320, scenYpos(I) + (vert * 2)
	       
	    CASE IS > 1000: 'Turbo put
	       QSpriteT scenName(I) - 1000, scen(I), scenYpos(I) + (vert * 2)
	       IF scen(I) < 0 THEN QSpriteT scenName(I) - 1000, scen(I) + 320, scenYpos(I) + (vert * 2)
	       IF scen(I) > 0 THEN QSpriteT scenName(I) - 1000, scen(I) - 320, scenYpos(I) + (vert * 2)
	       
	 END SELECT
	 
	 
      END IF
   NEXT I
   
   
   
   'Warp in correction
   IF gwPtr < 100 AND gwType > 0 THEN
      gwPtr = gwPtr + car(0).speed * 1.5
   ELSEIF gwPtr >= 100 THEN
      SELECT CASE gwType
	 CASE 1: vergeColL = gwCol
	 CASE 2: vergeColR = gwCol
	 CASE 3: roadCol = gwCol
      END SELECT
      gwType = 0
      gwPtr = 0
      gwCol = 0
   END IF
   
   
   'do yer stuff on top
   'wrap back
   FOR s = 0 TO OBJECTS
      
      
      IF car(0).speed > 0 THEN
	 'perspective calc
	 stepper(s) = ((stepper(s) * (SCENSPEED - car(0).speed)) \ ((SCENSPEED - 1) - car(0).speed)) + 1
      END IF
      
      
      'WRAP BACK ***
      'sprite changes & Hmod caried out during wrap back
      ' tickPtr is the next scenery slot to wrap back
      ' don't move this outside the 's' loop! Dunno why..
      
      
      tickTime = tickTime - car(0).speed
      
      
      IF tickTime < 1 THEN 'time to wrap the slot back & change contents
	 'if necessary. Each slot has 3 areas (l, r, top)
	 
	 
	 stepper(tickPtr) = 2
	 
	 IF countNextL > 0 THEN
	    stepsprL(tickPtr) = setNextL
	    countNextL = countNextL - 1
	    
	    
	    'change H mod?
	    IF countNextLM > 0 THEN
	       stepsprLM(tickPtr) = setNextLM
	       countNextLM = countNextLM - 1
	    END IF
	 END IF
	 
	 
	 IF countNextR > 0 THEN
	    stepsprR(tickPtr) = setNextR
	    countNextR = countNextR - 1
	    
	    
	    'change H mod?
	    IF countNextRM > 0 THEN
	       stepsprRM(tickPtr) = setNextRM
	       countNextRM = countNextRM - 1
	    END IF
	    
	    
	 END IF
	 
	 
	 IF countNextT > 0 THEN
	    stepsprT(tickPtr) = setNextT
	    countNextT = countNextT - 1
	 END IF
	 
	 tickPtr = tickPtr + 1
	 IF tickPtr > OBJECTS THEN tickPtr = 0
	 tickTime = (car(0).speed * 15) + 20
	 
	 
      END IF
   NEXT s
   
   'draw distant road %%%%%%%%%%%%%%%%%%
   
   
   'draw plain road
   FOR I = 2 TO 140
      lfbound = ((((190 - hz - (I * 6)) - VERTFACTOR) + rbendt \ I) - RWID) + I * 2: IF lfbound < 0 THEN lfbound = 0
      rgbound = ((((130 - hz + (I * 6)) + VERTFACTOR) + rbendt \ I) + RWID) - I * 2: IF rgbound > 319 THEN rgbound = 319
      dbound = (112 + I) - vert
      IF dbound < 200 THEN
	 'verge & road shadows
	 shadowFlag = 0
	 FOR s = 0 TO OBJECTS
	    IF I >= stepper(s) AND I <= stepper(s) + (I \ 3) AND (s = 1 OR s = 3 OR s = 5 OR s = 7) THEN shadowFlag = 1: EXIT FOR
	 NEXT s
	 
	 
	 IF shadowFlag = 1 THEN
	    IF gwType = 1 AND I <= gwPtr THEN
	       IF gwCol > 0 THEN QSlineH 0, lfbound - 1, dbound, gwCol + 1
	    ELSE
	       IF vergeColL > 0 THEN QSlineH 0, lfbound - 1, dbound, vergeColL + 1
	       
	    END IF
	    
	    IF gwType = 2 AND I <= gwPtr THEN
	       IF gwCol > 0 THEN QSlineH rgbound + 1, 319, dbound, gwCol + 1
	    ELSE
	       IF vergeColR > 0 THEN QSlineH rgbound + 1, 319, dbound, vergeColR + 1
	    END IF
	    
	    
	    IF gwType = 3 AND I <= gwPtr THEN
	       QSlineH lfbound, rgbound, dbound, gwCol
	    ELSE
	       QSlineH lfbound, rgbound, dbound, roadCol
	    END IF
	 ELSE
	    
	    
	    'draw road (correct for warp in)
	    IF gwType = 3 AND I <= gwPtr THEN
	       QSlineH lfbound, rgbound, dbound, gwCol + 1
	    ELSE
	       QSlineH lfbound, rgbound, dbound, roadCol + 1
	    END IF
	    
	    
	    'draw L verge (correct for warp in)
	    IF gwType = 1 AND I <= gwPtr THEN
	       IF gwCol > 0 THEN QSlineH 0, lfbound - 1, dbound, gwCol
	    ELSE
	       IF vergeColL > 0 THEN QSlineH 0, lfbound - 1, dbound, vergeColL
	    END IF
	    
	    
	    'draw R verge (correct for warp in)
	    IF gwType = 2 AND I <= gwPtr THEN
	       IF gwCol > 0 THEN QSlineH rgbound + 1, 319, dbound, gwCol
	    ELSE
	       IF vergeColR > 0 THEN QSlineH rgbound + 1, 319, dbound, vergeColR
	    END IF
	    
	    
	 END IF
      END IF
   NEXT I
   
   
   'sprite overlay
   
   REDIM marker(OBJECTS)
   REDIM order(OBJECTS)
   
   DO
      hiDist! = 1000: order(nextOrd) = 0
      
      
      
      FOR I = 0 TO OBJECTS
	 IF stepper(I) < hiDist! AND marker(I) = 0 THEN hiDist! = stepper(I): order(nextOrd) = I
      NEXT I
      
      
      marker(order(nextOrd)) = 1
      nextOrd = nextOrd + 1
      
      
   LOOP UNTIL nextOrd > OBJECTS
   
   'From here on, scenery is ordered in order()
   
   
   
   
   I = CSTimerFlag(1) 'this is used to set birdie flap speed
   
   
   FOR s = 0 TO OBJECTS
      
      
      
      scale = (stepper(order(s)) * 3) + (vert * 2)
      
      
      'colL/R are sprite basepoints (corrected for scale)
      'difL/R are correction based on TREE sprite
      
      down = ((110 - stepper(order(s))) - (vert * 2))' - ((i * stepsprRM(order(s))) \ 30)
      
      '77 is min height of 'non-flying' scenery sprite
      difL = 0: difR = 0
      
      'the test <>47 is a bodge for GATE sprites which
      'need to be anchored. Car will only collide with
      'anchored sprites.
      
      
      IF sprite(stepsprL(order(s))).h < 77 AND sprite(stepsprL(order(s))).h <> 47 THEN
	 difL = ((77 - sprite(stepsprL(order(s))).h) \ 2) * (scale / 64)
      ELSE
	 difL = ((99 - sprite(stepsprL(order(s))).h) \ 2) * (scale / 64)
      END IF
      
      IF sprite(stepsprR(order(s))).h < 77 AND sprite(stepsprR(order(s))).h <> 47 THEN
	 difR = ((77 - sprite(stepsprR(order(s))).h) \ 2) * (scale / 64)
      ELSE
	 difR = ((99 - sprite(stepsprR(order(s))).h) \ 2) * (scale / 64)
      END IF
      
      
      lfbound = ((((190 - hz - (stepper(order(s)) * 6)) - VERTFACTOR) + rbendt \ stepper(order(s))) - RWID) + stepper(order(s)) * 2
      rgbound = ((((130 - hz + (stepper(order(s)) * 6)) + VERTFACTOR) + rbendt \ stepper(order(s))) + RWID) - stepper(order(s)) * 2
      
      lfbound = lfbound - (stepper(order(s)) * stepsprLM(order(s)))
      rgbound = rgbound + (stepper(order(s)) * stepsprRM(order(s)))
      
      QSpriteS stepsprL(order(s)), lfbound, down + difL, scale
      QSpriteS stepsprR(order(s)), rgbound, down + difR, scale
      
      
      IF stepsprT(order(s)) <> -1 THEN
	 
	 IF stepsprT(order(s)) = 105 AND I THEN
	    stepsprT(order(s)) = 106
	 ELSEIF stepsprT(order(s)) = 106 AND I THEN
	    stepsprT(order(s)) = 105
	 END IF
	 
	 
	 
	 QSpriteS stepsprT(order(s)), lfbound + ((rgbound - lfbound) \ 2), down - (scale \ 2), scale
      END IF
      
      
      'collision check
      yourG = (((156 + bounce) - (vert * 6)) + sprite(car(0).sprite).h) - 20
      
      
      'colL, colR hold lowest pixel of spr
      IF scale > 64 AND car(0).setSpin = 0 THEN
	 colL = down + difL + ((sprite(stepsprL(order(s))).h \ 2) * (scale \ 64))
	 colR = down + difR + ((sprite(stepsprR(order(s))).h \ 2) * (scale \ 64))
	 
	 'leftmost & rightmost sprite edges corrected for scale
	 IF car(0).penalty = 0 THEN
	    IF colL > yourG AND lfbound + ((sprite(stepsprL(order(s))).W \ 2) * (scale \ 74)) > 160 - (sprite(car(0).sprite).W \ 2) THEN crashflag = -car(0).speed - bump: points = points - 25 * config(4): bump = bump + 2
	    IF colR > yourG AND rgbound - ((sprite(stepsprR(order(s))).W \ 2) * (scale \ 74)) < 160 + (sprite(car(0).sprite).W \ 2) THEN crashflag = car(0).speed + bump: points = points - 25 * config(4): bump = bump + 2
	 END IF
      END IF
      
      
   NEXT s
   
   
   'cars
   REDIM marker(totalCars)
   REDIM order(totalCars)
   nextOrd = 0
   
   
   DO
      hiDist! = -100: order(nextOrd) = 0
      
      
      FOR I = 0 TO totalCars
	 IF car(I).dist > hiDist! AND marker(I) = 0 THEN hiDist! = car(I).dist: order(nextOrd) = I
      NEXT I
      
      
      marker(order(nextOrd)) = 1
      nextOrd = nextOrd + 1
      
      
   LOOP UNTIL nextOrd > totalCars
   
   
   
   
   'From here on, cars are ordered in order()
   
   
   FOR I = 0 TO totalCars
      
      
      'GENERIC CALCS
      
      
      'car(0).airT = where it wants to be
      'car(0).air = where it is now
      
      
      IF car(I).airT > car(I).air THEN car(I).air = car(I).air + 4
      IF car(I).airT <= car(I).air THEN car(I).air = car(I).air - 4: car(I).airT = 0
      
      IF car(I).air < 0 THEN
	 car(I).air = 0
	 IF car(I).setSpin <> 0 THEN
	    car(I).setSpin = 0
	    DS4QB.AddSound 16, CURRENT, CURRENT, CURRENT, CURRENT: SFXCall = 1
	    'bad landing?
	    IF I = 0 AND car(0).angle > 45 AND car(0).angle < 325 THEN car(0).penalty = 40: car(0).MPH = 0
	 END IF
      END IF
      
      
      IF car(I).setSpin = 0 AND car(I).penalty = 0 THEN
	 IF car(I).angle > 0 AND car(I).angle < 180 THEN car(I).angle = car(I).angle - 6: IF car(I).angle < 0 THEN car(I).angle = 0
	 IF car(I).angle > 0 AND car(I).angle > 180 THEN car(I).angle = car(I).angle + 6: IF car(I).angle > 359 THEN car(I).angle = 0
      ELSE
	 car(I).angle = car(I).angle + car(I).setSpin
	 WHILE car(I).angle < 0
	    car(I).angle = car(I).angle + 360
	 WEND
	 car(I).angle = car(I).angle MOD 360
	 
	 
      END IF
      
      
      
   NEXT I
   
   
   FOR I = 0 TO totalCars
      
      IF car(order(I)).MPH > 90 THEN bounce = RND * 2
      SELECT CASE order(I)
	 
	 'YOUR CAR
	 CASE IS = 0:
	    oldRacePos = racePos
	    racePos = I + 1
	    IF racePos > oldRacePos THEN DS4QB.AddSound 28, CURRENT, CURRENT, CURRENT, CURRENT: SFXCall = 1
	    IF thisGame > 18 THEN
	       IF stopSiren = 0 AND racePos = 1 THEN
		  DS4QB.StopSound 10
		  stopSiren = 1
	       ELSEIF stopSiren = 1 AND racePos <> 1 THEN
		  DS4QB.AddSound 10, CURRENT, CURRENT, CURRENT, ACTIVE
		  SFXCall = 1
		  stopSiren = 0
	       END IF
	    END IF
	    
	    
	    'shadow
	    IF car(0).air > 0 THEN QSlineH 130, 190, 189 - (vert * 6), 199
	    
	    
	    SELECT CASE car(0).angle
	       CASE 0: QSprite steerSpr, 117, (156 + bounce) - (vert * 6) - car(0).air
	       CASE ELSE: QSpriteR steerSpr, 160, 175 + bounce - (vert * 6) - car(0).air, car(0).angle, 128
	    END SELECT
	    
	    
	    'wheel spray
	    IF wSpray > 0 AND car(0).speed > 0 AND car(0).air = 0 THEN
	       FOR j = 0 TO 30
		  gspset 110 + Dicef(100), 187 + Dicef(7) - (vert * 6), VARSEG(buffer(0)), VARPTR(buffer(0)), wSpray + Dicef(2)
	       NEXT j
	    END IF
	    
	    
	    'tyre smoke
	    IF smokin > 0 THEN
	       
	       
	       IF smokin < 3 THEN
		  QSprite 115, 125, 186 - (vert * 6)
	       ELSEIF smokin < 5 THEN
		  QSprite 116, 117, 186 - (vert * 6)
	       END IF
	       
	    END IF
	    
	    
	    'OTHER CARS
	 CASE IS > 0:
	    distdiff = (car(order(I)).dist - 100) - car(0).dist
	    
	    carSize = 55 - (distdiff \ 2)
	    
	    IF carSize > 66 THEN carSize = 66
	    IF carSize < 50 THEN bounce = 0
	    
	    IF distdiff > -250 AND distdiff < (160 + vert) AND (carSize - 10 - (vert * 2)) > 0 THEN
	       
	       'This is for Y coord
	       pPoint = (140 - (vert * 6)) - (distdiff \ 3): IF pPoint < 112 - vert THEN pPoint = 112 - vert
	       
	       'This is for X coord
	       bPoint = (28 - (distdiff \ 3))
	       carXpos = (160 + (car(order(I)).hOffset * bPoint)) - hz
	       
	       
	       'shadow
	       IF car(order(I)).air > 0 THEN QSlineH carXpos - (carSize \ 2), carXpos + (carSize \ 2), pPoint + 10, 199
	       
	       baseSpr = car(order(I)).sprite
	       IF carSize > 60 THEN
		  IF carXpos < 140 THEN baseSpr = baseSpr + 30 'turn right
		  IF carXpos > 180 THEN baseSpr = baseSpr + 20 'turn left
	       END IF
	       
	       
	       IF car(order(I)).angle <> 0 THEN
		  QSpriteR baseSpr, carXpos, pPoint + bounce - car(order(I)).air, car(order(I)).angle, carSize * 2
	       ELSE
		  QSpriteS baseSpr, carXpos, pPoint + bounce - car(order(I)).air, carSize
	       END IF
	       
	       
	       'CPU car collision with other CPU car
	       FOR ii = 1 TO totalCars
		  IF ii <> order(I) THEN 'cant crash with itself
		     IF car(order(I)).air = 0 AND car(order(I)).penalty = 0 AND ABS((car(order(I)).hOffset + 5) - (car(ii).hOffset + 5)) <= 3 AND ABS(car(order(I)).dist - car(ii).dist) < 15 THEN
			'crash
			IF car(order(I)).hOffset < car(ii).hOffset THEN
			   GOSUB CPUcarCrashL
			ELSE
			   GOSUB CPUcarCrashR
			END IF
		     END IF
		  END IF
	       NEXT ii
	       
	       
	       
	       'collision with you? car(0) w = 88 so -44 for collision correction
	       IF car(order(I)).air < 50 AND car(0).dist - car(order(I)).dist < 30 AND car(0).dist - car(order(I)).dist > -70 AND carXpos > 125 - (sprite(car(order(I)).sprite).W \ 2) AND carXpos < 195 + (sprite(car(order(I)).sprite).W \ 2) THEN
		  IF carXpos < 160 THEN
		     crashflag = crashflag - 1
		     'other car's angle
		     IF car(0).MPH > 70 THEN
			GOSUB CPUcarCrashL
			points = points + 50'smash
		     END IF
		     
		     
		     points = points + 50 + (25 * config(4))'prang
		     
		     
		     
		  ELSE
		     crashflag = crashflag + 1
		     'other car's angle
		     IF car(0).MPH > 70 THEN
			GOSUB CPUcarCrashR
			points = points + 50'smash
		     END IF
		     
		     
		     points = points + 50 + (25 * config(4))'prang
		     
		  END IF
		  
		  
		  'beep
		  IF Dicef(3) = 2 THEN DS4QB.AddSound 18, CURRENT, CURRENT, CURRENT, CURRENT: SFXCall = 1'bang!
		  
		  
		  IF car(order(I)).setSpin = 0 THEN car(order(I)).airT = 20
		  
	       END IF
	    END IF
	    
	    
      END SELECT
      
      
   NEXT I
   
   
   IF car(0).setSpin = 0 THEN
      IF crashflag < 0 THEN
	 car(0).hOffset = car(0).hOffset + 80
	 IF car(0).MPH > 70 THEN car(0).angle = 25
      ELSEIF crashflag > 0 THEN
	 car(0).hOffset = car(0).hOffset - 80
	 IF car(0).MPH > 70 THEN car(0).angle = (360 - 25)
      END IF
      
      
      IF crashflag <> 0 THEN
	 car(0).airT = (car(0).speed \ 2) * 10
	 car(0).MPH = car(0).MPH \ 2: IF car(0).MPH < 1 THEN car(0).MPH = 1
	 
	 
	 DS4QB.AddSound 3, CURRENT, CURRENT, CURRENT, CURRENT: SFXCall = 1'bang!
      END IF
      
      
      'flips
      SELECT CASE crashflag
	 CASE IS < -5:  car(0).setSpin = 11 + Dicef(12)
	    car(0).airT = (10 * car(0).speed) + 10
	    car(0).MPH = 80
	    
	    
	 CASE IS > 5:   car(0).setSpin = -11 - Dicef(12)
	    car(0).airT = (10 * car(0).speed) + 10
	    car(0).MPH = 80
      END SELECT
   END IF
   
   
   IF thisGame > 18 AND oldPoints < points THEN DS4QB.AddSound 7 + Dicef(2), CURRENT, CURRENT, CURRENT, CURRENT: SFXCall = 1
   
   
   IF rainFact > 0 THEN
      SELECT CASE rainStyle
	 CASE 0: QSRain rainFact
	 CASE 1: QSSnow rainFact
      END SELECT
   END IF
   EXIT SUB
   
   
CPUcarCrashL:
   
   car(order(I)).angle = 360 - 25
   car(order(I)).hOffset = car(order(I)).hOffset - 1
   IF car(order(I)).hOffset = -5 THEN car(order(I)).setSpin = 11 + Dicef(12): car(order(I)).airT = 100: car(order(I)).penalty = 500: points = points + (850 - (25 * config(4)))'BOOM!
   
   RETURN
   
   
CPUcarCrashR:
   
   car(order(I)).angle = 25
   car(order(I)).hOffset = car(order(I)).hOffset + 1
   IF car(order(I)).hOffset = 5 THEN car(order(I)).setSpin = -11 - Dicef(12): car(order(I)).airT = 100: car(order(I)).penalty = 500: points = points + (850 - (25 * config(4)))'BOOM!
   
   RETURN
END SUB

SUB frameOverlays

'WHAT DOES IT DO? : Displays overlays (race pos, time left, speed, etc)

   GFXnum Gear, 4, 177, 1
   GFXnum car(0).MPH, 11, 184, 2
   
   
   'lap time
   IF clockRun = 1 THEN
      race20s = race20s + 3
      IF race20s >= 100 THEN race20s = race20s - 100: raceSecs = raceSecs + 1: countDown = countDown - 1
      IF raceSecs = 60 THEN raceSecs = 0: raceMins = raceMins + 1
   END IF
   
   
   IF thisGame < 19 THEN 'display time
      QSprite 81, 192, 6 'lap sign
      
      
      dispTime raceMins, raceSecs, race20s, 232, 4
      
      
      'pos
      QSprite 99, 30, 6'pos sign
      GFXnum racePos, 70, 4, 0
      
   ELSE 'it's pursuit
      QSprite 46, 200, 6'points sign
      GFXnum points, 245, 4, 1
   END IF
   
   
   
   
   'time limit
   QSprite 80, 105, 6 'time sign
   GFXnum countDown, 150, 4, 1
   
   
END SUB

FUNCTION game2track (game%)

'WHAT DOES IT DO? : Decodes 'game' number into corresponding track

   j = game%
   IF j > 6 THEN
      'bring 'track' into valid range
      FOR I = 19 TO 7 STEP -6
	 IF j >= I THEN j = j - (I - 1)
      NEXT I
   END IF
   
   
   game2track = j
   
   
END FUNCTION

SUB gameComp
   
'WHAT DOES IT DO? : End game sequence
   
   DS4QB.StopMusic 7
   DS4QB.PlayMusic 8
   
   CSSetTimer 0, 30
   repKey = 1
   RESTORE trackData
   DO
      READ a$
   LOOP UNTIL a$ = "Track" + LTRIM$(STR$(4 + config(4)))
   READ a$
   
   
   angdir = 1
   DIM slotx(10)'xpos
   
   
   DIM c(10)'sprite number
   
   
   ii = 165
   
   FOR I = 0 TO 10
      c(I) = ii
      slotx(I) = I * 143
      ii = ii + 1: IF ii > 175 THEN ii = 165
   NEXT I
   
   
   DS4QB.PlaySound 5
   
   
   DO
      FOR I = 0 TO 10
	 slotx(I) = slotx(I) - 2
	 IF slotx(I) <= 0 - 143 THEN
	    
	    
	    'get biggest
	    big = 0
	    FOR ii = 0 TO 10
	       IF slotx(ii) > big THEN big = slotx(ii): j = c(ii)
	    NEXT ii
	    
	    slotx(I) = big + 143
	 END IF
      NEXT I
      
      
      ang = ang + angdir
      IF ang >= 45 THEN
	 angdir = -1
      ELSEIF ang <= -45 THEN
	 angdir = 1
      END IF
      
      
      QSBox 0, 0, 319, 199, 0
      
      
      
      
      FOR I = 0 TO 10
	 j = I + 5: IF j > 10 THEN j = j - 11
	 IF slotx(I) < 320 AND slotx(I) > -150 THEN
	    QSpriteT c(I), slotx(I), 15
	    QSpriteT c(j), slotx(I), 105
	 END IF
      NEXT I
      
      
      IF clPass = 0 THEN
	 QSpriteR 176, 159, 100, 360 + ang, 128
	 QSpriteS 60 + racePos, 159, 85, 128 + ang
	 dispTime raceMins, raceSecs, race20s, 120, 132
	 QSTextSp "congratulations`", 999, 20, 0
	 QSTextSp "shotgun run complete`", 999, 160, 0
      ELSEIF clPass = 1 AND config(2) < 4 + config(4) THEN
	 QSTextSp "new track available", 999, 20, 0
	 QSpriteT 149 + config(4), 79, 49
	 QSTextSp "enjoy " + a$ + "`", 999, 160, 0
      ELSE
	 vmod = vmod - 1
	 v2 = 0
	 
	 QSprite 94, 46, 92
	 QSprite 93, 66, 30
	 
	 
	 RESTORE credDat
	 DO
	    READ a$
	    IF a$ = "ENDLIST" THEN EXIT DO
	    IF a$ = "357" THEN GFXnum 357, 180, 200 + vmod + v2 - 25, 1
	    IF a$ = "2002" THEN GFXnum 2002, 230, 200 + vmod + v2 - 25, 1
	    QSTextSp a$, 999, 200 + vmod + v2, 0
	    v2 = v2 + 25
	 LOOP
	 IF vmod <= CREDITEND THEN clPass = 3
	 
	 
      END IF
      QSU
      
      
      IF NOT DQBkey(config(6)) THEN repKey = 0
      IF DQBkey(config(6)) AND repKey = 0 AND vmod = 0 THEN clPass = clPass + 1: repKey = 1
      
      
   LOOP UNTIL clPass > 2
   
   
   IF config(2) < 4 + config(4) THEN config(2) = 4 + config(4) 'allow new track
   CSSetTimer 0, 10
   
   
   IF config(4) = 2 THEN 'extra congrats screen
      VSFadeBlack 63
      QSBox 0, 0, 319, 199, 0'prevent flicker
      QSU
      QSpriteT 179, 23, 25
      QSpriteT 180, 163, 25
      QSU
      QSfadeBack "data\end"
      WHILE DQBkey(config(6)): WEND
	 WHILE NOT DQBkey(config(6)): WEND
	 END IF
	 
	 
	 QSfadeDown
	 DS4QB.StopMusic 8
	 DS4QB.PlayMusic 7
	 
	 
END SUB

FUNCTION Gear

'WHAT DOES IT DO? : Calculates gear based on speed

   currentGear = 1
   FOR I = 2 TO 6
      IF car(0).MPH >= gearShift(I) THEN currentGear = I
   NEXT I
   
   Gear = currentGear
END FUNCTION

SUB getCarCode

'WHAT DOES IT DO? : carCodes are a trailing pointer to course data.
'                   This allows for a delay between road bending &
'                   effect on car.
   
   
   cRbend = 0
   
   
   DO
      carCode = course(carCodePtr)
      carCodeDur = course(carCodePtr + 1)
      carCodeInt = course(carCodePtr + 2)
      
      
      'some codes only require a +2 ptr shift
      IF (carCode < 9 AND (carCode MOD 2) = 0) OR carCode = 80 THEN
	 carCodePtr = carCodePtr + 2
	 carCodeInt = 0
      ELSE
	 carCodePtr = carCodePtr + 3
      END IF
      
   LOOP UNTIL carCode < 9
   SELECT CASE carCode
      
      
      'CASE 1: vdir = 1'road up
      'CASE 5: vdir = -1'road down
      CASE 7: cRbend = -carCodeInt
      CASE 3: cRbend = carCodeInt
	 
	 
      CASE 4: cRbend = 0: 'centre H
      CASE 6: cRbend = 0: 'centre V + H
	 
	 
   END SELECT
END SUB

SUB getCode

'WHAT DOES IT DO? : Decode course data

   '0 = code, 1 = dur, 2= intensity, etc
   
   code = course(codePtr)
   codeDur = course(codePtr + 1)
   codeInt = course(codePtr + 2)
   
   rbend = 0: vdir = 0
   
   SELECT CASE code
      
      
      CASE 0: codePtr = codePtr - 1 'dont need 3rd parameter
	      codeInt = 0
	 
	 
      CASE 1: vdir = 1'road up
      CASE 5: vdir = -1'road down
      CASE 7: rbend = -codeInt 'left
      CASE 3: rbend = codeInt'right
	 
	 
      CASE 2: vdir = 0: codePtr = codePtr - 1'dont need 3rd parameter'centre V
      CASE 4: rbend = 0: codePtr = codePtr - 1'dont need 3rd parameter'centre H
      CASE 6: vdir = 0: rbend = 0: codePtr = codePtr - 1'dont need 3rd parameter'centre V + H
	 
	 
      CASE 10: setNextL = codeInt: countNextL = codeDur
      CASE 11: setNextR = codeInt: countNextR = codeDur
      CASE 12: setNextT = codeInt: countNextT = codeDur
	 
	 
      CASE 20: setNextLM = codeInt: countNextLM = codeDur
      CASE 21: setNextRM = codeInt: countNextRM = codeDur
      CASE 22: setNextTM = codeInt: countNextTM = codeDur
	 
      CASE 30: gwType = codeDur: gwCol = codeInt
	 
      CASE 40: wSpray = codeDur: trackSkid = codeInt + (rainFact \ 2)
	 
	 
	 'Inline sound calls
      CASE 50 AND codeInt = 0: DS4QB.AddSound codeDur, CURRENT, CURRENT, CURRENT, CURRENT: SFXCall = 1
      CASE 50 AND codeInt = 1: DS4QB.AddSound codeDur, CURRENT, CURRENT, CURRENT, ACTIVE: SFXCall = 1
      CASE 50 AND codeInt = 2: DS4QB.StopSound codeDur
	 'set volume
      CASE 51:
	 WHILE CSTimerFlag(2) = 0: WEND
	    DS4QB.StopSound codeDur
	    DS4QB.SetSoundAttr codeDur, CURRENT, codeInt, CURRENT, CURRENT, CURRENT
	    DS4QB.AddSound codeDur, CURRENT, CURRENT, CURRENT, ACTIVE: SFXCall = 1
	    
	    
	 CASE 60: rainFact = codeDur: rainStyle = codeInt: trackSkid = trackSkid + (rainFact \ 2)
	 CASE 70: scenName(codeDur) = codeInt
	 CASE 71: scenYpos(codeDur) = codeInt
	 CASE 72: scen(codeDur) = codeInt
	 CASE 73: scenMF(codeDur) = codeInt
	    
	    
	 CASE 80: countDown = countDown + codeDur
	    codePtr = codePtr - 1 'dont need 3rd parameter
	    DS4QB.AddSound 1, CURRENT, CURRENT, CURRENT, CURRENT: SFXCall = 1
	    
	    
      END SELECT
      
      
      IF code > 9 THEN codeDur = 0: codeInt = 0
      
      IF code = 100 THEN clockRun = 0: codeDur = 1000: DS4QB.AddSound 2, CURRENT, CURRENT, CURRENT, CURRENT: SFXCall = 1
      
      
      codePtr = codePtr + 3
END SUB

SUB GFXnum (numb%, x%, y%, style%)

'WHAT DOES IT DO? : Displays a number using arcade font

   'number to display, x & y coords, style 0=gold, 1=red,2=green
   
   
   n$ = LTRIM$(STR$(numb%))
   
   
   FOR dispDig = 1 TO LEN(n$)
      QSprite 50 + VAL(MID$(n$, dispDig, 1)) + (style * 10), x% + ((dispDig - 1) * 12), y%
   NEXT dispDig
   
   
END SUB

SUB GFXnumS (numb$, x%, y%, style%)

'WHAT DOES IT DO? : Displays a number using arcade font (accepts $tring)

   'number string to display, x & y coords, style 0=gold, 1=red
   
   
   FOR dispDig = 1 TO LEN(numb$)
      QSprite 50 + VAL(MID$(numb$, dispDig, 1)) + (style * 10), x% + ((dispDig - 1) * 12), y%
   NEXT dispDig
   
   
END SUB

SUB grWipe

'WHAT DOES IT DO?: clears screen & whizzes 'Ghini Run' logo past

   DS4QB.PlaySound 17
   gx = -209
   rx = 320
   
   
   DO
      QSBox 0, 0, 319, 199, 0
      
      QSpriteT 93, gx, 40
      QSprite 94, rx, 90
      
      
      QSU
      rx = rx - 10
      gx = gx + 10
   LOOP UNTIL gx >= 340
END SUB

SUB initSnd

'WHAT DOES IT DO? : Loads SFX/Music data

   PRINT "Load music data..";
   RESTORE musDat
   FOR I = 1 TO 8
      DS4QB.LoadMusic I, "data\" + LTRIM$(STR$(I)) + ".mo3", DEFAULT
      LOCATE CSRLIN, 18: PRINT INT((I / 8) * 100); "%";
      READ ii
      DS4QB.SetMusicAttr I, ii, CURRENT
   NEXT I
   
   PRINT : PRINT "Load SFX data..";
   FOR I = 1 TO 28
      LOCATE CSRLIN, 17: PRINT INT((I / 28) * 100); "%";
      tail$ = ".mp3": IF I = 7 OR I = 10 OR I = 22 OR I = 26 THEN tail$ = ".wav"
      DS4QB.LoadSound I, "data\" + LTRIM$(STR$(I)) + tail$, DEFAULT
      'change all volumes to 80
      DS4QB.SetSoundAttr I, CURRENT, 80, CURRENT, CURRENT, CURRENT
   NEXT I
   PRINT
   CLOSE 'all files
   
   
END SUB

SUB loadGfx

'WHAT DOES IT DO? : Loads GFX data from file archive to EMS

   DEF SEG = VARSEG(spr(0))
   FOR I = 1 TO LASTSPRITE
      j = FARLoad%(archHandle, I, "", VARSEG(spr(0)), VARPTR(spr(0)))
      IF j <> 0 THEN
	 PRINT "GFX ERROR @"; I
      ELSE
	 LOCATE CSRLIN, 12: PRINT INT((I / LASTSPRITE) * 100); "%";
	 'Get pixel dimensions
	 sprite(sprPtr).W = spr(0) \ 8
	 sprite(sprPtr).h = spr(1)
	 
	 
	 'sprite size (bytes)
	 sprite(sprPtr).byteSize = 4 + INT(((sprite(sprPtr).W + 1) * (8) + 7) \ 8) * 1 * (sprite(sprPtr).h + 1)
	 
	 
	 'palm tree fix
	 IF sprPtr = 11 THEN sprite(sprPtr).W = 3
	 'EMS pointer
	 sprite(sprPtr).memLoc = memOffsetPtr
	 
	 IF memMode = 0 THEN DQBPoke VARSEG(spr(0)), VARPTR(spr(0)), memOffsetPtr, sprite(sprPtr).byteSize
	 
	 
	 memOffsetPtr = memOffsetPtr + sprite(sprPtr).byteSize + 1
	 sprPtr = sprPtr + 1
	 
	 
      END IF
   NEXT I
   
   
   
   
   DEF SEG
END SUB

SUB loadTrack (num%)
  
'WHAT DOES IT DO? : Load track data from file->mem
   
   j = game2track(num%)
   'Load the course info
   IF Dicef(config(4) * 3) > 2 THEN j = j + 10
   handle = FREEFILE
   OPEN "data\ghini.run" FOR INPUT AS handle
   
   
   DO
      INPUT #handle, crap$
   LOOP UNTIL crap$ = "TRACK" + LTRIM$(STR$(j))
   
   
   INPUT #handle, crap$
   INPUT #handle, rainFact
   INPUT #handle, rainStyle
   
   INPUT #handle, crap$
   INPUT #handle, skyCol
   
   INPUT #handle, crap$
   INPUT #handle, vergeColL
   
   INPUT #handle, crap$
   INPUT #handle, vergeColR
   
   INPUT #handle, crap$
   INPUT #handle, roadCol
   
   INPUT #handle, crap$
   FOR I = 0 TO 3
      INPUT #handle, scenName(I)
      INPUT #handle, scenYpos(I)
      INPUT #handle, scen(I) 'starting X pos
      INPUT #handle, scenMF(I)'movement factor
   NEXT I
   
   
   INPUT #handle, crap$
   INPUT #handle, layerScroll
   
   
   'PROFILE ***----------
   
   
   INPUT #handle, crap$
   IF crap$ <> "PROFILE" THEN DQBclose: PRINT "Error before PROFILE": END
   
   
   FOR I = 0 TO OBJECTS
      stepper(I) = ((60 \ OBJECTS) * I) + 1
      
      
      INPUT #handle, nextCode
      stepsprL(I) = nextCode
      
      
      INPUT #handle, nextCode
      stepsprT(I) = nextCode
      
      
      INPUT #handle, nextCode
      stepsprR(I) = nextCode
      
      
      INPUT #handle, nextCode
      stepsprLM(I) = nextCode
      
      
      INPUT #handle, nextCode
      stepsprTM(I) = nextCode
      
      
      INPUT #handle, nextCode
      stepsprRM(I) = nextCode
   NEXT I
   
   
   '---------------------
   
   
   INPUT #handle, crap$
   IF crap$ <> "TRACKMAP" THEN DQBclose: PRINT "Error before TRACKMAP": END
   
   
   I = 0
   DO
      INPUT #handle, nextCode
      IF nextCode = 9999 THEN EXIT DO
      course(I) = nextCode
      I = I + 1
   LOOP
   
   
   CLOSE #handle
   
   
END SUB

FUNCTION mainMenu

'WHAT DOES IT DO? : Displays main game menu
   
   hLighted = 1 'current highed option
   repKey = 1
   DO
      blueTile 0 'blue tile bkgrd
      
      
      RESTORE menuDat
      
      FOR ii = 1 TO 6
	 READ a$
	 IF ii = hLighted THEN
	    QSTextSp a$, 999, (ii * 25) + 10, 2229
	 ELSE
	    QSTextSp a$, 999, (ii * 25) + 10, 0
	 END IF
      NEXT ii
      
      QSU
      
      
      'menu control
      'clear 'QSkey buffer'
      IF NOT DQBkey(config(8)) AND NOT DQBkey(config(9)) AND NOT DQBkey(config(6)) THEN repKey = 0
      
      IF hLighted > 1 AND repKey = 0 AND DQBkey(config(8)) THEN hLighted = hLighted - 1: repKey = 1
      IF hLighted < 6 AND repKey = 0 AND DQBkey(config(9)) THEN hLighted = hLighted + 1: repKey = 1
      IF DQBkey(config(6)) AND repKey = 0 THEN
	 mainMenu = hLighted
	 EXIT FUNCTION
      END IF
   LOOP
   
   
   
   
END FUNCTION

FUNCTION menuCtrl

'WHAT DOES IT DO? : Co-ordinates all other menu functions

   'Returns a game number (same as records) or 999 to quit
  
   DO
      
      
      SELECT CASE mainMenu
	 CASE 1: game = askGameType
	    IF game <> 999 THEN
	       course = 1 'default
	       SELECT CASE game
		  CASE 1: totalCars = 3 + (config(4) * 2)
		  CASE 2: yourcarModel = 1
		     totalCars = 3 + (config(4) * 2)
		     IF preRace(1) = 999 THEN course = 9999
		  CASE 3: totalCars = 0
		  CASE 4: yourcarModel = 9
		     totalCars = 7
		     IF preRace(2) = 999 THEN yourcarModel = 9999
	       END SELECT
	       
	       
	       IF game <> 2 THEN 'if not shotgun
		  
		  
		  IF game = 1 OR game = 3 THEN carSelect
		  IF yourcarModel = 9999 THEN
		     course = 9999
		  ELSE
		     course = trackSelect(game)
		  END IF
		  
	       END IF
	       
	       
	       IF course < 999 THEN EXIT DO
	    END IF
	    
	    
	 CASE 2: newDriver
	 CASE 3: CALL showRecords(askGameType)
	 CASE 4: CALL Options
	 CASE 5: CALL startScreen
	 CASE 6: course = 999
	    EXIT DO 'QUIT
      END SELECT
      
      
   LOOP
   
   
   IF course = 999 THEN
      menuCtrl = 999 ' quit
   ELSE
      course = course + ((game - 1) * 6)
      
      menuCtrl = course
   END IF
   
   
END FUNCTION

SUB newDriver
  
'WHAT DOES IT DO? : Requests new driver name

   DQBRemoveKeyboard 'cos it pauses on 'key down' so gotta use INKEY$..
   DO
      blueTile 1
      
      
      QSTextSp "Please enter your name", 25, 60, 0
      QSTextSp driver$, 999, 110, 0
      
      
      nc$ = INKEY$
      IF nc$ <> "" THEN
	 nc$ = LCASE$(nc$)
	 check = ASC(nc$)
	 
	 
	 IF check = 8 THEN
	    driver$ = "" 'reset on backspace
	 ELSEIF LEN(driver$) < 8 THEN
	    IF ASC(nc$) >= 97 AND ASC(nc$) <= 122 THEN
	       driver$ = driver$ + nc$
	    END IF
	    IF nc$ = " " THEN driver$ = driver$ + " "
	    driver$ = LTRIM$(driver$)
	 END IF
      END IF
      
      
      QSU
      
      
   LOOP UNTIL check = 13'Enter pressed
   
   
   IF driver$ = "" THEN driver$ = "PLAYER"
   driver$ = UCASE$(driver$)
   
   DQBInstallKeyboard ' all done, put it back
END SUB

SUB Options

'WHAT DOES IT DO? : displays 'Options' screen and sets global config() array

   repKey = 1
   hLighted = 1
   
   DIM a$(1 TO 4)
   
   
   DO
      SELECT CASE config(4) 'diff
	 CASE 0: a$(1) = "level rookie"
	 CASE 1: a$(1) = "level normal"
	 CASE 2: a$(1) = "level pro"
      END SELECT
      
      
      
      
      SELECT CASE config(0) 'speed
	 CASE 25: a$(2) = "speed slowpoke"
	 CASE 30: a$(2) = "speed normal"
	 CASE 35: a$(2) = "speed turbo"
	 CASE 40: a$(2) = "speed turbo x"
	 CASE 45: a$(2) = "speed turbo xx"
	 CASE 50: a$(2) = "speed turbo xxx"
      END SELECT
      
      
      SELECT CASE config(1) 'sync
	 CASE 0: a$(3) = "vsync a on"
	 CASE 1: a$(3) = "vsync b on"
	 CASE 2: a$(3) = "vsync off"
      END SELECT
      
      
      SELECT CASE config(13) 'lag
	 CASE 0: a$(4) = "sfx lag normal"
	 CASE 1: a$(4) = "sfx lag high"
      END SELECT
      
      
      
      
      blueTile 0
      
      FOR ii = 1 TO 4
	 
	 IF ii = hLighted THEN
	    QSTextSp a$(ii), 999, (ii * 25) + 30, 2229
	 ELSE
	    QSTextSp a$(ii), 999, (ii * 25) + 30, 0
	 END IF
      NEXT ii
      
      
      QSU
      
      
      'menu control
      'clear 'QSkey buffer'
      IF NOT DQBkey(config(8)) AND NOT DQBkey(config(9)) AND NOT DQBkey(config(6)) THEN repKey = 0
      
      IF hLighted > 1 AND repKey = 0 AND DQBkey(config(8)) THEN hLighted = hLighted - 1: repKey = 1
      IF hLighted < 4 AND repKey = 0 AND DQBkey(config(9)) THEN hLighted = hLighted + 1: repKey = 1
      IF DQBkey(config(6)) AND repKey = 0 THEN
	 SELECT CASE hLighted
	    CASE 1: config(4) = config(4) + 1: IF config(4) = 3 THEN config(4) = 0
	    CASE 2: config(0) = config(0) + 5: IF config(0) = 55 THEN config(0) = 25
	    CASE 3: config(1) = config(1) + 1: IF config(1) = 3 THEN config(1) = 0
	    CASE 4: config(13) = config(13) + 1: IF config(13) = 2 THEN config(13) = 0
	       
	       
	 END SELECT
	 repKey = 1
      END IF
      
      IF DQBkey(config(7)) AND repKey = 0 THEN EXIT DO
   LOOP
   
   
END SUB

SUB playerCarCtrl
   
'WHAT DOES IT DO? : Handles in-game player input
'                   Calculates new car horizontal position & speed
'                   Implements next course data

   'Pause?
   IF DQBkey(config(12)) AND code < 100 THEN
      QSTextSp "paused", 999, 90, 0
      QSU
      WHILE DQBkey(config(12)): WEND
	 DQBwaitkey (config(12))
      END IF
      
      steerSpr = car(0).sprite
      speedMod = -vert: IF speedMod < -3 THEN speedMod = -3
      
      'Self centering
      IF (NOT DQBkey(config(10)) OR NOT DQBkey(config(11))) AND car(0).hOffset > 0 THEN car(0).hOffset = car(0).hOffset - 2: IF car(0).hOffset = -1 THEN car(0).hOffset = 0
      IF (NOT DQBkey(config(10)) OR NOT DQBkey(config(11))) AND car(0).hOffset < 0 THEN car(0).hOffset = car(0).hOffset + 2: IF car(0).hOffset = 1 THEN car(0).hOffset = 0
     
      'skid recovery time
      IF NOT DQBkey(config(10)) AND NOT DQBkey(config(11)) THEN skidTime = skidTime - 30
     
      'move
      IF DQBkey(KEYESC) THEN code = 101: EXIT SUB
     
      tempSmoke = smokin
      
      
      IF car(0).penalty = 0 AND car(0).air = 0 THEN
	 IF car(0).MPH > 0 THEN
	    IF DQBkey(config(10)) AND NOT DQBkey(config(11)) AND car(0).air <= 0 THEN
	       car(0).hOffset = car(0).hOffset - (handling - car(0).speed)
	       
	       
	       'low speed steer bonus
	       IF car(0).speed <= 3 THEN car(0).hOffset = car(0).hOffset - 8
	      
	       steerSpr = steerSpr + 20
	       skidTime = skidTime + car(0).speed
	       speedMod = speedMod - 2
	    ELSEIF DQBkey(config(11)) AND NOT DQBkey(config(10)) AND car(0).air <= 0 THEN
	       car(0).hOffset = car(0).hOffset + (handling - car(0).speed)
	       
	       
	       'low speed steer bonus
	       IF car(0).speed <= 2 THEN car(0).hOffset = car(0).hOffset + 8
	       
	       
	       steerSpr = steerSpr + 30
	       skidTime = skidTime + car(0).speed
	       speedMod = speedMod - 2
	    END IF
	 END IF
	 
	 IF DQBkey(config(6)) AND car(0).MPH < car(0).maxMPH + speedMod AND code <> 100 THEN
	    'gearCycle increments until it reaches the req. gear power
	    gearCycle = gearCycle + 1
	    IF gearCycle >= (ABS(gearPow(Gear)) - speedMod) THEN
	       car(0).MPH = car(0).MPH + 1
	       gearCycle = 0
	    END IF
	    '-ve gearPow are turboed
	    IF gearPow(Gear) < 0 THEN car(0).MPH = car(0).MPH + ABS(gearPow(Gear))
	    
	    'tyre smoke
	    IF car(0).MPH < 30 THEN smokin = smokin + 1
	    
	 END IF
	 
	 
	 IF car(0).MPH > car(0).maxMPH + speedMod THEN car(0).MPH = car(0).maxMPH + speedMod
	 'is it top speed?
	 IF car(0).MPH > topSpeed THEN topSpeed = car(0).MPH
	 
	 
	 IF NOT DQBkey(config(6)) THEN car(0).MPH = car(0).MPH - 1
	 
	 
	 'tyre smoke & brakes
	 IF (DQBkey(config(7)) AND car(0).MPH > 0) OR code = 100 THEN
	    car(0).MPH = car(0).MPH - brakes
	    skidTime = skidTime - 30
	    IF car(0).MPH > 100 THEN smokin = smokin + 1: IF CSTimerFlag(3) THEN DS4QB.AddSound 4, CURRENT, CURRENT, CURRENT, CURRENT: SFXCall = 1
	 END IF
	 
	 
	 'trackSkid is the default skid value of the track
	 IF skidTime < trackSkid OR Gear < 4 THEN skidTime = trackSkid
	 IF skidTime > skidLimit + 50 THEN skidTime = skidLimit + 50
	 IF skidTime > skidLimit THEN
	    IF CSTimerFlag(3) THEN DS4QB.AddSound 4, CURRENT, CURRENT, CURRENT, CURRENT: SFXCall = 1
	    
	    
	    IF DQBkey(config(10)) AND car(0).air <= 0 THEN
	       car(0).hOffset = car(0).hOffset + 2: car(0).angle = 12: smokin = smokin + 1
	    ELSEIF DQBkey(config(11)) AND car(0).air <= 0 THEN
	       car(0).hOffset = car(0).hOffset - 2: car(0).angle = 348: smokin = smokin + 1
	    END IF
	    
	    
	    IF car(0).MPH > car(0).maxMPH - Dicef(20) THEN car(0).MPH = car(0).MPH - 1
	 END IF
      END IF
      
      
      IF car(0).speed >= 6 AND car(0).hOffset <> 0 THEN
	 steerSpr = car(0).sprite
	 IF car(0).hOffset < -2 THEN steerSpr = steerSpr + 20
	 IF car(0).hOffset > 2 THEN steerSpr = steerSpr + 30
      END IF
      
      
      IF tempSmoke = smokin THEN smokin = 0
      
      
      IF smokin > 4 THEN smokin = 1
      
      
      'car(0).hOffset is hz mod due to steering
      IF car(0).hOffset < -(20 - car(0).speed) THEN car(0).hOffset = -(20 - car(0).speed)
      IF car(0).hOffset > (20 - car(0).speed) THEN car(0).hOffset = (20 - car(0).speed)
     
      IF car(0).MPH < 0 THEN car(0).MPH = 0
      
      
      WHILE codeDur <= 0
	 getCode
      WEND
      IF car(0).dist > 40 AND carCodeDur <= 0 AND code <> 100 THEN getCarCode
      IF car(0).speed > 0 THEN
	 
	 
	 codeDur = codeDur - car(0).speed
	 IF car(I).MPH >= mphCycle THEN codeDur = codeDur - 1
	 IF car(0).dist > 40 THEN
	    carCodeDur = carCodeDur - car(0).speed
	    IF car(I).MPH >= mphCycle THEN carCodeDur = carCodeDur - 1
	    
	    
	    'Horiz centering code
	    
	    
	    IF carCode = 4 OR carCode = 6 THEN
	       IF cRbendt > 0 THEN cRbendt = cRbendt - 1
	       IF cRbendt < 0 THEN cRbendt = cRbendt + 1
	    END IF
	    IF (cRbend > 0 AND cRbendt < 180) OR (cRbend < 0 AND cRbendt > -180) THEN cRbendt = cRbendt + (cRbend * car(0).speed)
	 END IF
	 
	 
	 'Vert centering code
	 
	 
	 IF code = 2 OR code = 6 THEN
	    IF vert > 0 THEN vert = vert - 1
	    IF vert < 0 THEN vert = vert + 1
	 END IF
	 
	 
	 IF code = 4 OR code = 6 THEN
	    IF rbendt > 0 THEN rbendt = rbendt - 1
	    IF rbendt < 0 THEN rbendt = rbendt + 1
	 END IF
	 
	 
	 IF (rbend > 0 AND rbendt < 180) OR (rbend < 0 AND rbendt > -180) THEN rbendt = rbendt + (rbend * car(0).speed)
	 
	 
	 ' allow for 'wind-out' of road twist
	 
	 
	 'ensures that road bend < max steering rate (10)
	
	 hz = hz - cRbendt \ 10
	 
	 'limit the steering
	 IF hz > 340 THEN hz = 340
	 IF hz < -340 THEN hz = -340
	 hz = hz + car(0).hOffset
	 
	 IF vdir <> 0 THEN vert = vert + vdir
	 IF vert < -1 THEN vert = -1
	 IF vert > 10 THEN vert = 10
	
      END IF
      
      
      
      
      
END SUB

FUNCTION preRace (rType%)
  
'WHAT DOES IT DO? : Displays pre-race screen for Shotgun Run & Pursuit
   
   DIM track$(1 TO 6)
   
   
   FOR I = 1 TO 6
      RESTORE trackData
      DO
	 READ a$
      LOOP UNTIL a$ = "Track" + LTRIM$(STR$(I))
      READ a$
      track$(I) = a$
   NEXT I
   
   
   SELECT CASE config(4)
      CASE 0: d$ = "AMATEUR TROPHY"
      CASE 1: d$ = "INTERMEDIATE CUP"
      CASE 2: d$ = "PRO SUPERCUP"
   END SELECT
   
   repKey = 1
   DO
      IF NOT DQBkey(config(6)) AND NOT DQBkey(config(7)) THEN repKey = 0
      IF DQBkey(config(6)) AND repKey = 0 THEN EXIT DO
      IF DQBkey(config(7)) AND repKey = 0 THEN preRace = 999: EXIT FUNCTION
      blueTile 1
      
      r = r + 1: IF r = 360 THEN r = 0
      
      
      SELECT CASE rType%
	 CASE 1: QSpriteR 152, 210, 100, r, 128
	    QSTextSp "shotgun run", 999, 17, 0
	    QSText d$, 10, 57, 47
	    QSTextSp "top qualify each stage`", 999, 177, 0
	    GFXnum 3, 63, 176, 1
	    FOR I = 1 TO 4 + config(4)
	       QSText track$(I), 10 + (I * 5), 57 + (I * 17), 241 - I
	    NEXT I
	   
	    
	 CASE 2: QSpriteR 177, 210, 100, r, 128
	    QSTextSp "pursuit", 999, 17, 0
	    QSTextSp "run those lawbreakers", 999, 155, 0
	    QSTextSp "off the road`", 999, 177, 0
	    QSText "POINTS", 80, 50, 47
	    QSText "PRANG :", 23, 67, 134
	    GFXnum ((config(4) * 25) + 50), 90, 65, 2
	    QSText "CRASH :", 23, 87, 134
	    GFXnum ((config(4) * 25) + 100), 90, 85, 2
	    QSText "FLIP :", 23, 107, 134
	    GFXnum 1000, 90, 105, 2
	    QSText "BONUS :    x TIME", 23, 127, 134
	    GFXnum ((config(4) * 5) + 10), 90, 125, 2
      END SELECT
      QSU
   LOOP
   
   
END FUNCTION

REM $DYNAMIC
SUB QSBox (x1%, y1%, x2%, y2%, col%)

'WHAT DOES IT DO? : Draws a filled box to video buffer

   gsboxf VARSEG(buffer(0)), VARPTR(buffer(0)), x1%, y1%, x2%, y2%, col%
END SUB

SUB QSfadeBack (pal$)

'WHAT DOES IT DO? : Fades from black screen to given palette

   VSFadeToPalette pal$
END SUB

SUB QSfadeDown

'WHAT DOES IT DO? : Fade to black (& maintain palette)

   VSFadeBlack 63
   QSBox 0, 0, 319, 199, 0'prevent flicker
   QSU
   vspalette "data\ghini"
END SUB

SUB QSfadeUp

'WHAT DOES IT DO? : Fade to white

   VSFadeWhite 63
END SUB

SUB QSlineH (x1%, x2%, y2%, col%)

'WHAT DOES IT DO? : Draws a horizontal line

   gshline x1%, x2%, y2%, VARSEG(buffer(0)), VARPTR(buffer(0)), col%
END SUB

SUB QSMem2Spr (sprNum%)

'WHAT DOES IT DO? : Gets a sprite from EMS OR file archive to conventional mem
'                   (depending on whether EMS was availible at start up)

   SELECT CASE memMode
      CASE 0: DQBPeek VARSEG(spr(0)), VARPTR(spr(0)), sprite(sprNum%).memLoc, sprite(sprNum%).byteSize
      CASE 1: j = FARLoad%(archHandle, sprNum% + 1, "", VARSEG(spr(0)), VARPTR(spr(0)))
   END SELECT
   oldspr = sprNum%
   
   
END SUB

SUB QSprite (sprNum%, x%, y%)
  
'WHAT DOES IT DO? : Draws a sprite to the video buffer
   
   IF sprNum% <> oldspr THEN QSMem2Spr (sprNum%)
   gssprite x%, y%, VARSEG(buffer(0)), VARPTR(buffer(0)), VARSEG(spr(0)), VARPTR(spr(0))
END SUB

SUB QSpriteC (sprNum%, x%, y%, col%)

'WHAT DOES IT DO? : Draws a sprite to the video buffer, in 1 colour

   IF sprNum% <> oldspr THEN QSMem2Spr (sprNum%)
   
   VSSpriteC VARSEG(spr(0)), VARPTR(spr(0)), x%, y%, col%, VARSEG(buffer(0)), VARPTR(buffer(0))
   
   
END SUB

SUB QSpriteR (sprNum%, x%, y%, angle%, sval%)
  
'WHAT DOES IT DO? : Draws a rotated sprite to the buffer
   
   IF angle% < 0 THEN angle% = angle% + 360
   
   IF sprNum% <> oldspr THEN QSMem2Spr (sprNum%)
   VSSpriteR VARSEG(spr(0)), VARPTR(spr(0)), x%, y%, sval% * COS(angle% * 3.14159 / 180), sval% * SIN(angle% * 3.14159 / 180), VARSEG(buffer(0)), VARPTR(buffer(0))
END SUB

SUB QSpriteS (sprNum%, x%, y%, sval%)

'WHAT DOES IT DO? : Draws a scaled sprite to the buffer

   ' scalval = 0 to 255. 64 = 100%
   
   IF sprNum% <> oldspr THEN QSMem2Spr (sprNum%)
   
   VSSpriteS VARSEG(spr(0)), VARPTR(spr(0)), x%, y%, sval%, sval%, VARSEG(buffer(0)), VARPTR(buffer(0))
END SUB

REM $STATIC
SUB QSpriteT (sprNum%, x%, y%)

'WHAT DOES IT DO? : Draws a solid sprite to the buffer (v fast!)

   IF sprNum% <> oldspr THEN QSMem2Spr (sprNum%)
   gssolidput x%, y%, VARSEG(buffer(0)), VARPTR(buffer(0)), VARSEG(spr(0)), VARPTR(spr(0))
END SUB

SUB QSRain (pixels%)

'WHAT DOES IT DO? : Draws 'rain effect' overlay to buffer

   FOR I = 1 TO pixels%
      col% = 154: IF Dicef(2) = 2 THEN col% = 156
      x% = Dicef(319): y% = Dicef(199)
      gspset x%, y%, VARSEG(buffer(0)), VARPTR(buffer(0)), col%
      gspset x% + 1, y% - 1, VARSEG(buffer(0)), VARPTR(buffer(0)), col%
     
   NEXT
END SUB

SUB QSSnow (pixels%)

'WHAT DOES IT DO? : Draws 'snow effect' overlay to buffer

   FOR I = 1 TO pixels%
      col% = 158: IF Dicef(2) = 2 THEN col% = 159
      x% = Dicef(319): y% = Dicef(199)
      gspset x%, y%, VARSEG(buffer(0)), VARPTR(buffer(0)), col%
      
      
      
      
      
   NEXT
   
   
END SUB

REM $DYNAMIC
SUB QSText (text$, x%, y%, col1%)
   
'WHAT DOES IT DO? : Draws shadowed text to video buffer

   IF x% = 999 THEN x% = ((40 - LEN(text$)) / 2) * 8
   VSShadowFont VARSEG(buffer(0)), VARPTR(buffer(0)), x%, y%, text$, col1%, col1% - 5, 0, 0
END SUB

REM $STATIC
SUB QSTextSp (text$, x%, y%, mode%)
   
'WHAT DOES IT DO? : Draws text to buffer using arcade font

   'mode 1 to 360 = rotation factor
   'mode 1000+ = scale factor + 1000
   'mode 2000+ = box col +2000
   
   
   text$ = LCASE$(LTRIM$(text$))
   IF LEN(text$) > 0 AND y% > -20 AND y% < 200 THEN
      
      
      IF x% = 999 THEN ' centre text
	 
	 FOR I = 1 TO LEN(text$)
	    nextChar = ASC(MID$(text$, I, 1)) + 23' 23 is sprite offset
	    IF nextChar >= 119 AND nextChar <= 145 THEN xlen% = xlen% + sprite(nextChar).W + 2
	    IF nextChar = 55 THEN xlen% = xlen% + 14 'space
	 NEXT I
	 xlen% = xlen% - 2
	 x% = (319 - xlen%) \ 2
      END IF
      
      'Boxed text
      IF mode% >= 2000 THEN
	 FOR I = 0 TO 9
	    QSBox x% - 2, (y% + I) - 1, x% + xlen% + 2, y% + 18 - I, mode% - (2000 - I)
	 NEXT I
      END IF
      
      
      mode% = 0
      
      
      FOR I = 1 TO LEN(text$)
	 
	 nextChar = ASC(MID$(text$, I, 1)) + 23' 23 is sprite offset
	 
	 
	 IF (nextChar >= 119 AND nextChar <= 145) OR nextChar = 56 THEN
	    SELECT CASE mode%
	       
	       
	       CASE 0: QSprite nextChar, x% + push, y%
	       CASE 1 TO 360: QSpriteR nextChar, x% + push, y%, mode%, 128
	       CASE 1000 TO 1999: QSpriteS nextChar, x% + (push * ((mode% - 1000) / 64)), y%, mode% - 1000
		  
	    END SELECT
	 END IF
	 push = push + sprite(nextChar).W + 2
      NEXT I
      
      
   END IF 'text >0
   
   
END SUB

REM $DYNAMIC
SUB QSU 'QSUpdateScreen

'WHAT DOES IT DO? : Copy video buffer to screen

   IF config(1) = 0 THEN WAIT &H3DA, 8: WAIT &H3DA, 8, 8
   CSWaitTimer 0
   IF config(1) = 1 THEN WAIT &H3DA, 8: WAIT &H3DA, 8, 8
   gspcopy VARSEG(buffer(0)), VARPTR(buffer(0)), &HA000, 0' buffer to screen (solid mode)
END SUB

REM $STATIC
SUB raceResults
   
'WHAT DOES IT DO? : Displays 'race results' screen & calculates finish order

   'get final race order
   
   
   DIM marker(totalCars)
   DIM order(totalCars)
   DIM driver$(7)
   nextOrd = 0
   repKey = 1
   DO
      hiDist! = -100: hiCar = 0
      
      
      FOR I = 0 TO totalCars
	 IF car(I).dist > hiDist! AND marker(I) = 0 THEN
	    hiDist! = car(I).dist
	    hiCar = I
	 END IF
      NEXT I
      
      
      order(nextOrd) = hiCar: marker(hiCar) = 1
      nextOrd = nextOrd + 1
      
      
   LOOP UNTIL nextOrd > totalCars
   
   RESTORE driverDat
   FOR I = 0 TO 7
      READ a$
      driver$(I) = a$
   NEXT I
   
   'From here on, cars are ordered in order()
   
   
   RESTORE recSelDat
   FOR I = 1 TO ((thisGame - 1) \ 6) + 1
      READ t$
   NEXT I
   
   
   
   
   DO
      IF NOT DQBkey(config(6)) AND NOT DQBkey(config(7)) THEN repKey = 0
      IF DQBkey(config(6)) AND repKey = 0 THEN EXIT DO
      blueTile 1
      
      QSpriteR 145 + game2track(thisGame), 159, 100, r, 128
      
      r = r + 1: IF r = 360 THEN r = 0
      
      
      QSTextSp "race results", 999, 17, 0
      
      
      FOR I = 0 TO totalCars
	 GFXnum I + 1, 20, 50 + I * 18, 2
	 QSpriteS car(order(I)).sprite, 55, 55 + I * 18, 25
	 IF car(order(I)).sprite = yourcarModel THEN
	    QSText driver$, 80, 53 + I * 18, 182
	    
	 ELSE
	    QSText driver$(car(order(I)).sprite - 1), 80, 53 + I * 18, 134
	 END IF
      NEXT I
      
      
      IF thisGame < 19 THEN
	 QSText "RACE TIME", 210, 50, 134
	 dispTime raceMins, raceSecs, race20s, 210, 65
      ELSE
	 QSText "SCORE", 210, 50, 134
	 GFXnum points, 210, 65, 1
      END IF
      
      
      QSText "MAX SPEED", 210, 95, 134
      QSText LTRIM$(STR$(topSpeed)) + " MPH", 210, 105, 47
      QSText "GAME TYPE", 210, 125, 134
      QSText t$, 210, 135, 47
      QSText "NEXT RACE", 210, 155, 134
      IF thisGame >= 7 AND thisGame <= 12 THEN
	 IF racePos <= 3 THEN
	    QSText "QUALIFIED!", 210, 165, 47
	 ELSE
	    QSText "GAME OVER", 210, 165, 47
	    code = 999'quit after this screen
	 END IF
      ELSE
	 QSText "T.B.A.", 210, 165, 47
      END IF
      
      
      QSU
   LOOP
   
   
END SUB

FUNCTION recordCtrl (action%)

'WHAT DOES IT DO? : Retrieves, updates, save or resets records
'                   Uses custom format more memory efficient than
'                   standard GET/PUT records.

   ' Records are held in string 'record$' in format
   ' min/sec(*10)/sec/subsec(*10)/subsec/car/name(8 chars)/rec number (2 digits)
   
   
   'Record numbers 1-6 (Arcade) 7-12 (Shotgun) 13-18(TT) 19-24 (pursuit)
   
   
   IF action% = 0 THEN
      'compare & update if neccesary
      ' returns 1 if new record, else 0
      
      
      'Have to tally new& like this to avoid overflow.
      raceMins& = raceMins
      new& = (raceMins& * 10000) + (raceSecs * 100) + race20s
      
      old& = VAL(LEFT$(record$, 6))
      
      
      'If its pursuit then..
      IF thisGame >= 19 THEN
	 new& = points
	 result& = new& - old&
      ELSE
	 result& = old& - new&
      END IF
      
      
      IF result& > 0 THEN 'it's a new record
	 
	 
	 a$ = LTRIM$(STR$(new&))
	 
	 WHILE LEN(a$) < 6
	    a$ = "0" + a$
	    WEND'make it 6 digits
	    
	    
	    d$ = driver$
	    WHILE LEN(d$) < 8: d$ = d$ + " ": WEND'make it 8 chars
	       record$ = a$ + LTRIM$(STR$(yourcarModel)) + d$ + RIGHT$(record$, 2)
	       
	       'write record to disk....
	       'copy whole file
	       inFile = FREEFILE
	       OPEN "data\record.dat" FOR INPUT AS #inFile
	       
	       
	       outFile = FREEFILE
	       OPEN "data\record.tmp" FOR OUTPUT AS #outFile
	       
	       
	       FOR I = 1 TO 24 'all records
		  INPUT #inFile, d$
		  IF I = VAL(RIGHT$(record$, 2)) THEN d$ = record$
		  PRINT #outFile, d$
	       NEXT
	       
	       
	       CLOSE 'all files
	       KILL "data\record.dat"
	       NAME "data\record.tmp" AS "data\record.dat"
	       
	       
	       GOSUB getChecksum
	       config(5) = checkSum
	       dump 2 'update
	       recordCtrl = 1
	    ELSE
	       recordCtrl = 0
	    END IF
	    
	    
	 ELSEIF action% = 999 THEN
	    'reset all records
	    handle = FREEFILE
	    OPEN "data\record.dat" FOR OUTPUT AS #handle
	    FOR I = 1 TO 18
	       PRINT #handle, "1959991ghinirun" + LTRIM$(STR$(I))
	    NEXT
	    FOR I = 19 TO 24
	       PRINT #handle, "0010009ghinirun" + LTRIM$(STR$(I))
	    NEXT
	    
	    
	    CLOSE #handle
	    recordCtrl = 0
	    
	    
	 ELSEIF action% = 888 THEN
	    'checkSum
	    GOSUB getChecksum
	    IF checkSum <> config(5) THEN
	       recordCtrl = checkSum
	    ELSE
	       recordCtrl = 0
	    END IF
	    
	    
	 ELSE
	    'get a record
	    handle = FREEFILE
	    OPEN "data\record.dat" FOR INPUT AS #handle
	    WHILE VAL(RIGHT$(record$, 2)) <> action%
	       INPUT #handle, record$
	    WEND
	    CLOSE #handle
	    recordCtrl = 0
	 END IF
	 EXIT FUNCTION
	 
	 
getChecksum:
	 checkSumL! = 0
	 handle = FREEFILE
	 OPEN "data\record.dat" FOR INPUT AS #handle
	 FOR I = 1 TO 24 'all records
	    INPUT #handle, d$
	    FOR j = 1 TO LEN(d$)
	       checkSumL! = checkSumL! + ASC(MID$(d$, j, 1))
	    NEXT j
	 NEXT I
	 CLOSE handle
	 
	 
	 WHILE checkSumL! > 32000: checkSumL! = checkSumL! - 1000: WEND
	    checkSum = checkSumL!
	    
	    
	    RETURN
END FUNCTION

REM $DYNAMIC
SUB Restart

'WHAT DOES IT DO? : Decides what to do once a race has ended, & sets
'                   up the next race

reAsk:
   IF thisGame < 7 OR thisGame > 10 + config(4) OR code > 100 THEN 'goto menu
      'just started, or a single game just finished, or aborted
      thisGame = menuCtrl
      
      IF thisGame = 7 THEN GOSUB trackIntro
      
      
   ELSE 'its mid shotgun game (7 to 12)
      
      thisGame = thisGame + 1
      IF thisGame = 11 + config(4) THEN 'game complete!
	 'end sequence
	 gameComp
	 thisGame = 99
      ELSE
	 GOSUB trackIntro
      END IF
   END IF
   
   'QUIT
   IF thisGame = 99 THEN GOTO reAsk
   IF thisGame = 999 THEN code = 999: EXIT SUB'quit prog
   
   CALL clearVarbs
   
   loadTrack thisGame
   grWipe
   
   EXIT SUB
   
   
trackIntro:
   
   I = trackZoom(game2track(thisGame), 99)
   
   WHILE NOT DQBkey(config(6)): WEND
      RETURN
END SUB

REM $STATIC
SUB showRecords (raceType%)

'WHAT DOES IT DO? : Displays the 'records' screen

   '1 = Arcade
   '2 = Champ
   '3 = T Attack
   '4 = Pursuit
   '999 = none

   IF raceType% = 999 THEN EXIT SUB
   DIM tile(1): DIM Slot(1)
   DIM temp(1 TO 6) AS STRING * 17
   repKey = 1: r = 1
   
   
   FOR I = 0 TO 1
      Slot(I) = 160 + (I * 240)
      tile(I) = 146 + (I * 2)
   NEXT I
   
   
   FOR I = (raceType% * 6) - 5 TO (raceType% * 6)
      temp = recordCtrl(I)
      temp$(r) = record$ 'assign to array to stop reppa file access
      r = r + 1
   NEXT I
   
   
   vmod = 160: dir = -1
   
   
   DO
      blueTile 1 'blue tile bkgrd
      
      
      FOR I = 0 TO 1
	 QSpriteR tile(I), Slot(I), 100, r, 128
	 Slot(I) = Slot(I) + 2
	 IF Slot(I) > 400 THEN
	    Slot(I) = -80
	    tile(I) = tile(I) + 1: IF tile(I) > 151 THEN tile(I) = 146
	 END IF
      NEXT I
      
      r = r + 2: IF r > 359 THEN r = 0
      
      'Show race type txt
      RESTORE recSelDat
      FOR I = 1 TO raceType%
	 READ a$
      NEXT I
      
      
      QSTextSp a$ + " Records", 999, 17 + vmod, 0
      FOR I = 1 TO 6
	 RESTORE trackData
	 DO
	    READ a$
	 LOOP UNTIL a$ = "Track" + LTRIM$(STR$(I))
	 READ a$
	 
	 
	 'mini car
	 QSpriteS VAL(MID$(temp(I), 7, 1)) + 30, 70, (60 * I) + vmod + 14, 32
	 
	 IF ((60 * I) + vmod - 10) < 189 AND ((60 * I) + vmod - 10) > 0 THEN QSText a$, 35, (60 * I) + vmod - 10, 134
	 
	 IF raceType% = 4 THEN 'Pursuit scores
	    GFXnumS MID$(temp(I), 1, 6), 108, (60 * I) + vmod + 3, 1
	 ELSE
	    dispTime VAL(LEFT$(temp(I), 2)), VAL(MID$(temp(I), 3, 2)), VAL(MID$(temp(I), 5, 2)), 100, (60 * I) + vmod + 5
	 END IF
	 
	 
	 
	 
	 'name
	 QSTextSp MID$(temp(I), 8, 8), 200, (60 * I) + vmod + 5, 0
      NEXT I
      QSU
      
      
      IF DQBkey(config(8)) THEN dir = 1
      IF DQBkey(config(9)) THEN dir = -1
      
      
      IF NOT DQBkey(config(7)) THEN repKey = 0
      IF repKey = 0 AND DQBkey(config(7)) THEN EXIT DO
      
      
      IF dir = -1 AND vmod > -200 THEN vmod = vmod - 1
      IF dir = 1 AND vmod < 0 THEN vmod = vmod + 1
   LOOP
   
   
END SUB

SUB sndFlush

'WHAT DOES IT DO? : Sounds added to the sound buffer are not played
'                   until 'flushed' here. This routine is called when
'                   SFXCall > -2 and is normally done several times
'                   as DS4QB sometimes ignores FLUSH requests
   
   IF SFXCall > -2 THEN 'flush the sound queue
      DS4QB.PlaySounds
      SFXCall = SFXCall - 1
   END IF
   
   
   'engine
   IF CSTimerFlag(2) AND oldMPH <> car(0).MPH THEN
      IF Gear > 1 THEN inAt = gearShift(Gear)
      outAt = car(0).maxMPH: IF Gear < 6 THEN outAt = gearShift(Gear + 1)
      'step size
      DS4QB.SetSoundAttr 7, (6000 + ((11000 \ (outAt - inAt)) * (car(0).MPH - inAt))) + Gear * 1300, CURRENT, CURRENT, CURRENT, CURRENT
      
      oldMPH = car(0).MPH
   END IF
   
END SUB

SUB startRace

'WHAT DOES IT DO? : Does race start countdown 3.. 2.. 1.. GO!
   
   DS4QB.StopMusic 7
   
   DS4QB.PlayMusic game2track(thisGame)
   DS4QB.AddSound 7, 6000, CURRENT, CURRENT, ACTIVE
   DS4QB.AddSound 14, CURRENT, CURRENT, CURRENT, CURRENT
   SFXCall = 1
   I = 3
   DO
      ii = ii + 8
      IF ii = 24 THEN DS4QB.AddSound 10 + I, CURRENT, CURRENT, CURRENT, CURRENT: SFXCall = 1
      IF ii >= 256 THEN I = I - 1: ii = 16
      Frame
      sndFlush
      QSpriteS 60 + I, 159, 100, ii
      frameOverlays
      QSU
   LOOP UNTIL I = 0
   DS4QB.AddSound 15, CURRENT, CURRENT, CURRENT, CURRENT
   IF thisGame > 18 THEN DS4QB.AddSound 10, CURRENT, CURRENT, CURRENT, ACTIVE
   SFXCall = 1
   clockRun = 1
   
   
END SUB

SUB startScreen

'WHAT DOES IT DO? : Ghini Run intro screen

   CSSetTimer 0, 30
   fx = 0: scmod = 64: scmod2 = 40
   scdir = -1: tree = -190: cmod = 1: cmod2 = 1: scdir2 = -1
   startTime! = TIMER
   carMod = 400
   gx = -209
   rx = 320
   DS4QB.PlaySound 17
   
   DO
      'sky & road boxes
      QSBox 0, 0, 320, 60, 92
      
      'clouds
      QSpriteT 49, -320 + cloud, 45
      QSpriteT 49, 0 + cloud, 45
      
      cloud = cloud + 1
      IF cloud = 320 THEN cloud = 0
      
      QSprite 83, -320 + distScen, 85
      QSprite 83, 0 + distScen, 85
      
      QSpriteT 10, -320 + distScen, 105
      QSpriteT 10, 0 + distScen, 105
      
      distScen = distScen + 2
      IF distScen > 320 THEN distScen = 0: QSprite 92, -110 + farBnk, 99

      QSprite 92, 0 + farBnk, 99
      QSprite 92, 110 + farBnk, 99
      QSprite 92, 220 + farBnk, 99
      
      
      farBnk = farBnk + 8: IF farBnk > 110 THEN farBnk = 0
      
      
      roadOff = roadOff + 14: IF roadOff >= 80 THEN roadOff = 0
      FOR I = -1 TO 4
	 QSpriteT 95, (I * 80) + roadOff, 128
      NEXT I
      
      
      tree = tree + 12: IF tree >= 180 THEN tree = 0
      FOR I = -1 TO 1
	 QSprite 11, (I * 180) + tree, 29
      NEXT I
      
      
      IF vmod < 0 THEN
	 QSpriteS 91, carMod, 130, scmod
	 IF carMod < -20 THEN cmod = 1
	 IF carMod > 310 THEN cmod = -1
	 carMod = carMod + cmod
      END IF
      
      
      FOR I = -110 TO 220 STEP 110
	 QSprite 92, I + nearBnk, 154
      NEXT I
      
      
      nearBnk = nearBnk + 16: IF nearBnk > 110 THEN nearBnk = 0
      
      
      scmod = scmod + scdir: IF scmod > 80 THEN scdir = -1
      IF scmod < 60 THEN scdir = 1
      
      
      IF scdir <> 0 AND Dicef(100) > 90 THEN scdir = 0
      IF scdir = 0 AND Dicef(100) > 90 THEN scdir = 1
      IF scdir = 0 AND Dicef(100) > 90 THEN scdir = -1
      
      
      IF rocks < 319 THEN QSprite 0, rocks, 125
      rocks = rocks + 20
      IF rocks > 320 AND INT(RND * 100) > 95 THEN rocks = -190
      
      
      IF vmod > (-92 - sprite(94).h) THEN
	 QSprite 94, rx, 92 + vmod
	 QSprite 93, gx, 30 + vmod
      END IF
      
      
      IF gx <= 65 THEN
	 gx = gx + spedi
	 rx = rx - spedi
	 spedi = spedi + .6
      ELSEIF TIMER - startTime! > 3 THEN
	 vmod = vmod - 1
	 IF vmod < -40 AND DQBkey(config(6)) THEN EXIT DO
	 v2 = 0
	 RESTORE credDat
	 DO
	    READ a$
	    IF a$ = "ENDLIST" THEN EXIT DO
	    IF a$ = "357" THEN GFXnum 357, 180, 200 + vmod + v2 - 25, 1
	    IF a$ = "2002" THEN GFXnum 2002, 230, 200 + vmod + v2 - 25, 0
	    QSTextSp a$, 999, 200 + vmod + v2, 0
	    v2 = v2 + 25
	 LOOP
      END IF
      
      
      QSU
      
      
   LOOP UNTIL vmod <= CREDITEND
   CSSetTimer 0, 10
   QSfadeDown
END SUB

FUNCTION trackSelect (game%)

'WHAT DOES IT DO? : Draw 'select track' screen & returns selected value

   'currentTrack% is the starting track displayed
   'game% is passed to get record for trackZoom
   
   startx = 79: startY = 49
   currentTrack% = 1
   repKey = 1
   
   
   DO
      
      
      IF NOT DQBkey(config(6)) AND NOT DQBkey(config(7)) AND NOT DQBkey(config(10)) AND NOT DQBkey(config(11)) THEN repKey = 0
      
      
      pre = currentTrack%
      IF DQBkey(config(6)) AND repKey = 0 AND config(2) >= currentTrack% THEN
	 repKey = 1
	 chosen = trackZoom(currentTrack%, game%)
	 IF chosen = 1 THEN EXIT DO
      END IF
      
      blueTile 1
      QSpriteT 145 + currentTrack%, startx, startY
      
      IF DQBkey(config(7)) AND repKey = 0 THEN currentTrack% = 9999: EXIT DO
      IF DQBkey(config(10)) AND repKey = 0 THEN currentTrack% = currentTrack% - 1: repKey = 1
      IF DQBkey(config(11)) AND repKey = 0 THEN currentTrack% = currentTrack% + 1: repKey = 1
      IF currentTrack% = 7 THEN currentTrack% = 6
      IF currentTrack% = 0 THEN currentTrack% = 1
      
      
      IF pre < currentTrack% THEN 'shift right
	 
	 
	 
	 FOR I = startx TO -160 STEP -4
	    blueTile 1
	    QSpriteT 145 + currentTrack%, I + 240, startY
	    QSpriteT 145 + pre, I, startY
	    QSTextSp "Select course", 999, 138, 0
	    QSU
	 NEXT I
	 
	 
      ELSEIF pre > currentTrack% THEN 'shift left
	 
	 
	 
	 FOR I = startx TO 320 STEP 4
	    blueTile 1
	    QSpriteT 145 + currentTrack%, I - 240, startY
	    QSpriteT 145 + pre, I, startY
	    QSTextSp "Select course", 999, 138, 0
	    QSU
	 NEXT I
      ELSE
	 IF config(2) >= currentTrack% THEN
	    QSTextSp "Select course", 999, 138, 0
	 ELSE
	    QSTextSp "not available`", 999, 138, 0
	 END IF
	 
	 
	 'This code moves to the start of the relevant data
	 RESTORE trackData
	 DO
	    READ a$
	 LOOP UNTIL a$ = "Track" + LTRIM$(STR$(currentTrack%))
	 
	 
	 'header,col
	 READ a$
	 
	 QSTextSp a$, 999, 17, 0
	 
	 
      END IF
      
      
      QSU
   LOOP
   trackSelect = currentTrack%
  
   
END FUNCTION

FUNCTION trackZoom (track%, game%)

'WHAT DOES IT DO? : Show track details, records, game type, etc.

   'out =0, in =1
   IF game% = 99 THEN game% = 2: sgr = 1'it's a shotgun game
   inOut% = 1
   RESTORE recSelDat
   FOR I = 1 TO game%
      READ t$
   NEXT I
   
   
   I = recordCtrl(((game% - 1) * 6) + track%)
   SELECT CASE config(4)
      CASE 0: d$ = "ROOKIE"
      CASE 1: d$ = "NORMAL"
      CASE 2: d$ = "PRO"
   END SELECT
   
   
   repKey = 1
   'This code moves to the start of the relevant data
   RESTORE trackData
   DO
      READ a$
   LOOP UNTIL a$ = "Track" + LTRIM$(STR$(track%))
   
   
   'header,col
   READ a$
   DIM b$(2)
   'fix the track desc
   FOR I = 0 TO 2
      READ b$
      b$(I) = b$
   NEXT I
   
   
   I = 49
   
   DO
      IF NOT DQBkey(config(6)) AND NOT DQBkey(config(7)) AND NOT DQBkey(config(10)) AND NOT DQBkey(config(11)) THEN repKey = 0
      
      IF inOut% = 0 THEN
	 IF I < 49 THEN
	    I = I + 2: repKey = 1
	 ELSE
	    EXIT DO 'zoomed out, now bomb out
	 END IF
	 
      ELSEIF inOut% = 1 THEN
	 IF I >= 20 THEN I = I - 2: repKey = 1
      END IF
      
      blueTile 1
      
      QSpriteT 145 + track%, (2 * I) - 21, I'pic
      QSTextSp a$, 999, 17, 0' title
      QSText "TRACK RECORD", 112, 125, 47
      
      
      'your car
      QSprite yourcarModel + 30, 50 - (2 * I), 80
      
      
      'name
      QSTextSp MID$(record$, 8, 8), 200, 138, 0
      'mini car
      QSpriteS VAL(MID$(record$, 7, 1)) + 30, 65, 145, 32
      
      
      IF game% = 4 THEN 'Pursuit scores
	 GFXnumS MID$(record$, 1, 6), 110, 138, 1
      ELSE
	 dispTime VAL(LEFT$(record$, 2)), VAL(MID$(record$, 3, 2)), VAL(MID$(record$, 5, 2)), 95, 138
      END IF
      
      
      'track desc, col
      IF I = 19 THEN
	 QSText b$(0), 5, 165, 134
	 QSText b$(1), 5, 175, 134
	 QSText b$(2), 5, 185, 134
      END IF
      
      
      QSText "GAME TYPE", 190 + I, 55, 134
      QSText t$, 190 + I, 65, 47
      QSText "DIFFICULTY", 190 + I, 85, 134
      QSText d$, 190 + I, 95, 47
      QSU
      
      
      IF DQBkey(config(7)) AND inOut% = 1 AND repKey = 0 AND sgr = 0 THEN
	 inOut% = 0
      ELSEIF DQBkey(config(6)) AND inOut% = 1 AND repKey = 0 THEN
	 inOut% = 1
	 EXIT DO'track chosen
      END IF
      
      
   LOOP
   
   
   trackZoom = inOut%
   
   
END FUNCTION

SUB updateAllCarPos

'WHAT DOES IT DO? : Updates relative car positions (distance)
'                   including 'freeze' penalty following a crash

   mphCycle = mphCycle + 1
   IF mphCycle > 250 THEN mphCycle = 0
   
   
   FOR I = 0 TO totalCars
      IF car(I).penalty = 0 THEN
	 car(I).speed = car(I).MPH \ 28
	 
	 'make sure car is moving when speedo >0
	 IF car(I).MPH > 0 AND car(I).speed < 1 THEN car(I).speed = 1
	 IF car(I).dist < 32000 AND clockRun = 1 THEN car(I).dist = car(I).dist + car(I).speed
	
	 IF car(I).MPH >= mphCycle THEN car(I).dist = car(I).dist + 1
	
	 'other cars
	 IF I > 0 AND car(I).MPH <= car(I).maxMPH AND car(I).setSpin = 0 AND clockRun = 1 THEN car(I).MPH = car(I).MPH + Dicef(10)
      ELSE
	 'car is undergoing penalty
	 IF car(I).penalty = 1 THEN
	    car(I).angle = 0
	    
	    IF I = 0 THEN
	       hz = 0
	       car(0).MPH = 0
	       car(I).hOffset = 0
	    ELSE
	       car(I).hOffset = -5 + Dicef(9)
	    END IF
	 END IF
	 
	 car(I).penalty = car(I).penalty - 1
	 car(I).speed = 0
	 
      END IF
   NEXT I
   
   
   IF points < 0 THEN points = 0
   
   
END SUB

